/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.rxloader;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import ru.arturvasilov.rxloader.LifecycleHandler;
import ru.arturvasilov.rxloader.RxLoader;
import rx.Observable;

public class LoaderLifecycleHandler
implements LifecycleHandler {
    private final Context mContext;
    private final LoaderManager mLoaderManager;

    @NonNull
    public static LifecycleHandler create(@NonNull Context context, @NonNull LoaderManager loaderManager) {
        return new LoaderLifecycleHandler(context, loaderManager);
    }

    private LoaderLifecycleHandler(@NonNull Context context, @NonNull LoaderManager loaderManager) {
        this.mContext = context;
        this.mLoaderManager = loaderManager;
    }

    @Override
    @NonNull
    public <T> Observable.Transformer<T, T> load(final @IdRes int loaderId) {
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> observable) {
                if (LoaderLifecycleHandler.this.mLoaderManager.getLoader(loaderId) == null) {
                    LoaderLifecycleHandler.this.mLoaderManager.initLoader(loaderId, Bundle.EMPTY, new RxLoaderCallbacks(observable));
                }
                RxLoader loader = (RxLoader)LoaderLifecycleHandler.this.mLoaderManager.getLoader(loaderId);
                return loader.createObservable();
            }
        };
    }

    @Override
    @NonNull
    public <T> Observable.Transformer<T, T> reload(final @IdRes int loaderId) {
        return new Observable.Transformer<T, T>(){

            public Observable<T> call(Observable<T> observable) {
                LoaderLifecycleHandler.this.mLoaderManager.restartLoader(loaderId, Bundle.EMPTY, new RxLoaderCallbacks(observable));
                RxLoader loader = (RxLoader)LoaderLifecycleHandler.this.mLoaderManager.getLoader(loaderId);
                return loader.createObservable();
            }
        };
    }

    @Override
    public void clear(int id) {
        this.mLoaderManager.destroyLoader(id);
    }

    private class RxLoaderCallbacks<D>
    implements LoaderManager.LoaderCallbacks<D> {
        private final Observable<D> mObservable;

        public RxLoaderCallbacks(Observable<D> observable) {
            this.mObservable = observable;
        }

        @NonNull
        public Loader<D> onCreateLoader(int id, Bundle args) {
            return new RxLoader<D>(LoaderLifecycleHandler.this.mContext, this.mObservable);
        }

        public void onLoadFinished(Loader<D> loader, D data) {
        }

        public void onLoaderReset(Loader<D> loader) {
        }
    }
}

