/*
 * Decompiled with CFR 0.152.
 */
package ru.androidpirates.permissions.retriever;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.PluralsRes;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.androidpirates.permissions.retriever.R;

public class PermissionRetriever {
    private static final String LOG_TAG = "PermissionRetriever";
    private static final int REQUEST_PERMISSIONS_CODE = 1689;
    @Nullable
    private Runnable mPendingIfGrantedAction;
    @Nullable
    private Runnable mPendingIfUnacceptedAction;
    @Nullable
    private android.support.v4.app.Fragment mAppCompatFragment;
    @Nullable
    private Fragment mFragment;
    @Nullable
    private Activity mActivity;
    private Boolean mIsLoggingEnabled;
    private Boolean mIsSilentMode;
    private boolean mIsRewriteProtectionDisabled = true;
    private Map<String, Object> mPermissionsRationalesMap = new HashMap<String, Object>();

    public static boolean hasPermission(Object caller, String permission) {
        return PermissionRetriever.hasPermission(PermissionRetriever.getContextFromCaller(caller), permission);
    }

    public static boolean hasAllPermissions(Object caller, String ... permissions) {
        Context context = PermissionRetriever.getContextFromCaller(caller);
        for (String permission : permissions) {
            if (PermissionRetriever.hasPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAllPermissions(Object caller, List<String> permissions) {
        return PermissionRetriever.hasAllPermissions(caller, permissions.toArray(new String[permissions.size()]));
    }

    public PermissionRetriever silentMode(boolean isSilentMode) {
        if (this.mIsRewriteProtectionDisabled) {
            this.mIsSilentMode = isSilentMode;
        } else {
            this.logRewriteProtectionEnabled();
        }
        return this;
    }

    public PermissionRetriever logging(boolean isLoggingEnabled) {
        if (this.mIsRewriteProtectionDisabled) {
            this.mIsLoggingEnabled = isLoggingEnabled;
        } else {
            this.logRewriteProtectionEnabled();
        }
        return this;
    }

    public PermissionRetriever withPermission(@NonNull String permission) {
        return this.withPermission(permission, null);
    }

    public PermissionRetriever withPermission(@NonNull String permission, @StringRes int explanation) {
        if (this.mIsRewriteProtectionDisabled) {
            if (!TextUtils.isEmpty((CharSequence)permission)) {
                this.mPermissionsRationalesMap.put(permission, explanation);
            }
        } else {
            this.logRewriteProtectionEnabled();
        }
        return this;
    }

    public PermissionRetriever withPermission(@NonNull String permission, @Nullable String explanation) {
        if (this.mIsRewriteProtectionDisabled) {
            if (!TextUtils.isEmpty((CharSequence)permission)) {
                this.mPermissionsRationalesMap.put(permission, explanation);
            }
        } else {
            this.logRewriteProtectionEnabled();
        }
        return this;
    }

    public void run(@NonNull Object caller) {
        this.run(caller, null);
    }

    public void run(@NonNull Object caller, @Nullable Runnable ifGranted) {
        this.run(caller, ifGranted, null);
    }

    public void run(@NonNull Object caller, @Nullable Runnable ifGranted, @Nullable Runnable ifUnaccepted) {
        if (this.mIsRewriteProtectionDisabled) {
            this.setTrueCaller(caller);
            this.mPendingIfGrantedAction = ifGranted;
            this.mPendingIfUnacceptedAction = ifUnaccepted;
            if (this.mIsSilentMode == null) {
                this.mIsSilentMode = Global.getInstance().mIsSilentMode;
            }
            if (this.mIsLoggingEnabled == null) {
                this.mIsLoggingEnabled = Global.getInstance().mIsLoggingEnabled;
            }
            this.mIsRewriteProtectionDisabled = false;
            this.checkAndRun();
        } else {
            this.logRewriteProtectionEnabled();
        }
    }

    public boolean onPermissionResult(int requestCode) {
        if (requestCode != 1689) {
            return false;
        }
        if (this.getContext() != null) {
            if (this.check()) {
                this.runGranted();
            } else if (this.somePermissionPermanentlyDenied()) {
                this.showRationaleToSettings();
            } else {
                this.showRationaleToRequest();
            }
        } else if (this.mIsLoggingEnabled.booleanValue()) {
            Log.e((String)LOG_TAG, (String)"Context is null. I'm gonna do nothing!!!");
        }
        return true;
    }

    public void clear() {
        this.mPermissionsRationalesMap.clear();
        this.mIsSilentMode = false;
        this.mFragment = null;
        this.mIsSilentMode = null;
        this.mIsLoggingEnabled = null;
        this.mAppCompatFragment = null;
        this.mActivity = null;
        this.mPendingIfGrantedAction = null;
        this.mPendingIfUnacceptedAction = null;
        this.mIsRewriteProtectionDisabled = true;
    }

    private void logRewriteProtectionEnabled() {
        if (this.mIsLoggingEnabled.booleanValue()) {
            Log.e((String)LOG_TAG, (String)("Rewrite protection is enabled, call clear() for re-use this instance. @" + this.hashCode()));
        }
    }

    private static boolean hasPermission(Context context, String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    private static Context getContextFromCaller(Object caller) throws IllegalArgumentException {
        if (caller instanceof Fragment) {
            return ((Fragment)caller).getActivity();
        }
        if (caller instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)caller).getActivity();
        }
        if (caller instanceof Activity) {
            return (Activity)caller;
        }
        throw new IllegalArgumentException("Cant get context from caller");
    }

    private void setTrueCaller(Object caller) throws IllegalArgumentException {
        if (caller instanceof Fragment) {
            this.mFragment = (Fragment)caller;
        } else if (caller instanceof android.support.v4.app.Fragment) {
            this.mAppCompatFragment = (android.support.v4.app.Fragment)caller;
        } else if (caller instanceof Activity) {
            this.mActivity = (Activity)caller;
        } else {
            throw new IllegalArgumentException("Passed wrong caller object");
        }
    }

    private void checkAndRun() {
        if (this.getContext() != null) {
            if (this.check()) {
                this.runGranted();
            } else if (this.shouldShowRationale()) {
                this.showRationaleToRequest();
            } else {
                this.request();
            }
        } else if (this.mIsLoggingEnabled.booleanValue()) {
            Log.e((String)LOG_TAG, (String)"Context is null. I'm gonna do nothing!!!");
        }
    }

    private boolean check() {
        boolean allGranted = true;
        if (!this.mPermissionsRationalesMap.isEmpty()) {
            ArrayList<Map.Entry<String, Object>> granted = new ArrayList<Map.Entry<String, Object>>();
            for (Map.Entry<String, Object> entry : this.mPermissionsRationalesMap.entrySet()) {
                if (PermissionRetriever.hasPermission(this.getContext(), entry.getKey())) {
                    granted.add(entry);
                    continue;
                }
                allGranted = false;
            }
            this.mPermissionsRationalesMap.entrySet().removeAll(granted);
        }
        return allGranted;
    }

    private void runGranted() {
        if (this.mPendingIfGrantedAction != null) {
            this.mPendingIfGrantedAction.run();
        }
        this.clear();
    }

    private void runUnaccepted() {
        if (this.mPendingIfUnacceptedAction != null) {
            this.mPendingIfUnacceptedAction.run();
        }
        this.clear();
    }

    private void request() {
        Set<String> permissionsSet = this.mPermissionsRationalesMap.keySet();
        this.requestPermissions(permissionsSet.toArray(new String[permissionsSet.size()]));
    }

    private void requestPermissions(String[] permissions) {
        if (this.mAppCompatFragment != null) {
            this.mAppCompatFragment.requestPermissions(permissions, 1689);
        } else if (this.mFragment != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mFragment.requestPermissions(permissions, 1689);
            } else if (this.mIsLoggingEnabled.booleanValue()) {
                Log.e((String)LOG_TAG, (String)"Current sdk < 23 ver api and used platform's Fragment. Request permissions wasn't called");
            }
        } else {
            ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])permissions, (int)1689);
        }
    }

    private boolean somePermissionPermanentlyDenied() {
        for (String permission : this.mPermissionsRationalesMap.keySet()) {
            if (this.shouldShowRequestPermissionRationale(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldShowRationale() {
        for (String permission : this.mPermissionsRationalesMap.keySet()) {
            if (!this.shouldShowRequestPermissionRationale(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldShowRequestPermissionRationale(String permission) {
        if (this.mAppCompatFragment != null) {
            return this.mAppCompatFragment.shouldShowRequestPermissionRationale(permission);
        }
        if (this.mFragment != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                return this.mFragment.shouldShowRequestPermissionRationale(permission);
            }
            if (this.mIsLoggingEnabled.booleanValue()) {
                Log.w((String)LOG_TAG, (String)"Current sdk < 23 ver api and used platform's Fragment. Trying to get value from Activity.shouldShowRequestPermissionRationale()");
            }
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mActivity, (String)permission);
        }
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mActivity, (String)permission);
    }

    private void showRationaleToRequest() {
        if (!this.mIsSilentMode.booleanValue()) {
            this.prepareDialog().setPositiveButton(R.string.perm_retriever_button_ask_again, (d, i) -> this.request()).show();
        } else {
            this.runUnaccepted();
        }
    }

    private void showRationaleToSettings() {
        if (!this.mIsSilentMode.booleanValue()) {
            this.prepareDialog().setPositiveButton(R.string.perm_retriever_button_settings, (d, i) -> this.getContext().startActivity(this.intentToSettings())).show();
        } else {
            this.runUnaccepted();
        }
    }

    private AlertDialog.Builder prepareDialog() {
        int permCount = this.mPermissionsRationalesMap.size();
        StringBuilder message = new StringBuilder(this.getPlurals(R.plurals.perm_retriever_message_denied, permCount));
        for (Map.Entry<String, Object> entry : this.mPermissionsRationalesMap.entrySet()) {
            String value;
            message.append("\n").append(this.cutPermissionName(entry.getKey()));
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof Integer) {
                int value2 = (Integer)entry.getValue();
                if (value2 == -1) continue;
                message.append(" - ").append(this.getContext().getString(value2));
                continue;
            }
            if (!(entry.getValue() instanceof String) || TextUtils.isEmpty((CharSequence)(value = (String)entry.getValue()))) continue;
            message.append(" - ").append(value);
        }
        return new AlertDialog.Builder(this.getContext()).setTitle((CharSequence)this.getPlurals(R.plurals.perm_retriever_title_denied, permCount)).setMessage((CharSequence)message).setOnCancelListener(d -> this.runUnaccepted()).setNegativeButton(R.string.perm_retriever_button_cancel, (d, i) -> this.runUnaccepted());
    }

    private String cutPermissionName(String permission) {
        int lastDotIndex = permission.lastIndexOf(46) + 1;
        return permission.substring(lastDotIndex).replace("_", " ");
    }

    private Intent intentToSettings() {
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)this.getContext().getPackageName(), null));
    }

    private Context getContext() {
        if (this.mFragment != null) {
            return this.mFragment.getActivity();
        }
        if (this.mAppCompatFragment != null) {
            return this.mAppCompatFragment.getActivity();
        }
        return this.mActivity;
    }

    private String getPlurals(@PluralsRes int id, int quantity) {
        return this.getContext().getResources().getQuantityString(id, quantity);
    }

    public static class Global {
        private static Global sInstance;
        private boolean mIsLoggingEnabled = false;
        private boolean mIsSilentMode = false;

        private Global() {
        }

        private static Global getInstance() {
            if (sInstance == null) {
                sInstance = new Global();
            }
            return sInstance;
        }

        public static void setSilentMode(boolean silentMode) {
            Global.getInstance().mIsSilentMode = silentMode;
        }

        public static void setLoggingEnabled(boolean loggingEnabled) {
            Global.getInstance().mIsLoggingEnabled = loggingEnabled;
        }
    }
}

