/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.websocket.WebSocketConnection;

public class WebSocketContext {
    private final List<WebSocketConnection> connections;
    private final WebSocketConnection connection;
    private final Map<String, ParameterValue> pathParameters;

    public WebSocketContext(List<WebSocketConnection> connections, WebSocketConnection connection, Map<String, String> pathParameters) {
        this.connections = connections;
        this.connection = connection;
        this.pathParameters = new HashMap<String, ParameterValue>(pathParameters.size());
        for (String name : pathParameters.keySet()) {
            this.pathParameters.put(name, new ParameterValue(pathParameters.get(name)));
        }
    }

    public WebSocketConnection getConnection() {
        return this.connection;
    }

    public List<WebSocketConnection> getConnections() {
        return this.connections;
    }

    public void sendMessage(String message) throws IOException {
        this.connection.sendMessage(message);
    }

    public void broadcastMessage(String message) throws IOException {
        for (WebSocketConnection connection : this.connections) {
            connection.sendMessage(message);
        }
    }

    public Map<String, ParameterValue> getPathParameters() {
        return this.pathParameters;
    }

    public ParameterValue getPathParameter(String name) {
        if (!this.getPathParameters().containsKey(name)) {
            return new ParameterValue(new String[0]);
        }
        return this.getPathParameters().get(name);
    }
}

