/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static List<String> getList(String s, String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            String[] chunks;
            for (String chunk : chunks = s.split(separator + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                if ((chunk = chunk.trim()).length() <= 0) continue;
                if (chunk.charAt(0) == '\"' && chunk.charAt(chunk.length() - 1) == '\"') {
                    chunk = chunk.substring(1, chunk.length() - 1).trim();
                }
                strings.add(chunk);
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(strings);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isNullOrEmpty(str) || StringUtils.isNullOrEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isNullOrEmpty(str) || StringUtils.isNullOrEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String addStart(String str, String add) {
        if (StringUtils.isNullOrEmpty(add)) {
            return str;
        }
        if (StringUtils.isNullOrEmpty(str)) {
            return add;
        }
        if (!str.startsWith(add)) {
            return add + str;
        }
        return str;
    }

    public static String addEnd(String str, String add) {
        if (StringUtils.isNullOrEmpty(add)) {
            return str;
        }
        if (StringUtils.isNullOrEmpty(str)) {
            return add;
        }
        if (!str.endsWith(add)) {
            return str + add;
        }
        return str;
    }

    public static String format(String str, Object ... args) {
        str = str.replaceAll("\\{}", "%s");
        return String.format(str, args);
    }

    public static String getFileExtension(String value) {
        int index = value.lastIndexOf(46);
        if (index > -1) {
            return value.substring(index + 1);
        }
        return "";
    }

    public static String getPrefix(String input, char delimiter) {
        int index = input.indexOf(delimiter);
        if (index > -1) {
            return input.substring(0, index);
        }
        return input;
    }
}

