/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.util.ClasspathUtils;
import ro.pippo.core.util.StringUtils;

public class MimeTypes {
    private static final Logger log = LoggerFactory.getLogger(MimeTypes.class);
    private final Properties mimetypes;
    private final Pattern extPattern;
    private final PippoSettings pippoSettings;

    public MimeTypes(PippoSettings pippoSettings) {
        this.pippoSettings = pippoSettings;
        this.extPattern = Pattern.compile("^.*\\.([^.]+)$");
        this.mimetypes = new Properties();
        this.init();
    }

    public String getMimeType(String filename) {
        return this.getMimeType(filename, "");
    }

    public String getMimeType(String filename, String defaultMimeType) {
        Matcher matcher = this.extPattern.matcher(filename.toLowerCase());
        String ext = "";
        if (matcher.matches()) {
            ext = matcher.group(1);
        }
        if (ext.length() > 0) {
            String mimeType = this.mimetypes.getProperty(ext);
            if (mimeType == null) {
                return defaultMimeType;
            }
            return mimeType;
        }
        return defaultMimeType;
    }

    public String getContentType(String filename) {
        return this.getContentType(filename, "application/octet-stream");
    }

    public String getContentType(String filename, String defaultContentType) {
        String contentType = this.getMimeType(filename, null);
        if (contentType == null) {
            contentType = defaultContentType;
        }
        if (contentType != null && contentType.startsWith("text/")) {
            return contentType + "; charset=utf-8";
        }
        return contentType;
    }

    public boolean isValidMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (mimeType.indexOf(";") != -1) {
            return this.mimetypes.contains(mimeType.split(";")[0]);
        }
        return this.mimetypes.contains(mimeType);
    }

    private void init() {
        URL url = ClasspathUtils.locateOnClasspath("pippo/mime-types.properties");
        if (url == null) {
            log.error("Could not locate '{}'!", (Object)"pippo/mime-types.properties");
        } else {
            try {
                InputStream is = url.openStream();
                Object object = null;
                try {
                    this.mimetypes.load(is);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        List<String> settingNames = this.pippoSettings.getSettingNames("mimetype.");
        for (String key : settingNames) {
            String type = key.substring("mimetype.".length()).toLowerCase();
            String value = this.pippoSettings.getString(key, null);
            if (StringUtils.isNullOrEmpty(value)) continue;
            this.mimetypes.setProperty(type, value);
        }
    }
}

