/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    public static final String HMAC_MD5 = "HmacMD5";
    public static final String HMAC_SHA1 = "HmacSHA1";
    public static final String HMAC_SHA256 = "HmacSHA256";

    private CryptoUtils() {
    }

    public static String getHmacSHA256(String message, String secretKey) {
        return CryptoUtils.hmacDigest(message, secretKey, HMAC_SHA256);
    }

    public static String getHmacSHA1(String message, String secretKey) {
        return CryptoUtils.hmacDigest(message, secretKey, HMAC_SHA1);
    }

    public static String getHmacMD5(String message, String secretKey) {
        return CryptoUtils.hmacDigest(message, secretKey, HMAC_MD5);
    }

    public static String hmacDigest(String message, String secretKey, String algorithm) {
        String digest = null;
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
            byte[] bytes = mac.doFinal(message.getBytes(StandardCharsets.US_ASCII));
            digest = CryptoUtils.toHex(bytes);
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return digest;
    }

    public static String getHashSHA256(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
        return CryptoUtils.getHashSHA256(bytes);
    }

    public static String getHashSHA256(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            return CryptoUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    public static String getHashSHA1(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
        return CryptoUtils.getHashSHA1(bytes);
    }

    public static String getHashSHA1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            return CryptoUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    public static String getHashMD5(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.ISO_8859_1);
        return CryptoUtils.getHashMD5(bytes);
    }

    public static String getHashMD5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            return CryptoUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder hash = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hash.append('0');
            }
            hash.append(hex);
        }
        return hash.toString();
    }

    public static String generateSecretKey() {
        return CryptoUtils.hmacDigest(UUID.randomUUID().toString(), UUID.randomUUID().toString(), HMAC_SHA256);
    }
}

