/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;

public class ClasspathUtils {
    private static final Logger log = LoggerFactory.getLogger(ClasspathUtils.class);

    private ClasspathUtils() {
    }

    public static URL locateOnClasspath(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (url = loader.getResource(resourceName)) != null) {
            log.debug("Located '{}' in the context classpath", (Object)resourceName);
        }
        if (url == null && (url = ClassLoader.getSystemResource(resourceName)) != null) {
            log.debug("Located '{}' in the system classpath", (Object)resourceName);
        }
        return url;
    }

    public static List<URL> getResources(String name) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                list.add(url);
            }
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
        return list;
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

