/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.ResourceHandler;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.StringUtils;

public abstract class UrlResourceHandler
extends ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(UrlResourceHandler.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("-ver-[0-9a-f]+\\.");

    public UrlResourceHandler(String urlPath) {
        super(urlPath);
    }

    @Override
    public final void handleResource(String resourcePath, RouteContext routeContext) {
        URL url = this.getResourceUrl(resourcePath);
        if (url != null) {
            this.streamResource(url, routeContext);
        }
    }

    public abstract URL getResourceUrl(String var1);

    protected String getResourceVersion(String resourcePath) {
        String version = null;
        URL resourceUrl = this.getResourceUrl(resourcePath);
        if (resourceUrl != null) {
            try {
                version = Long.toString(resourceUrl.openConnection().getLastModified());
            }
            catch (IOException | NullPointerException e) {
                log.error("Failed to read lastModified property for {}", (Object)resourceUrl, (Object)e);
            }
        }
        return version;
    }

    @Override
    public String injectVersion(String resourcePath) {
        String version = this.getResourceVersion(resourcePath);
        if (StringUtils.isNullOrEmpty(version)) {
            return resourcePath;
        }
        int extensionAt = resourcePath.lastIndexOf(46);
        StringBuilder versionedResourcePath = new StringBuilder();
        if (extensionAt == -1) {
            versionedResourcePath.append(resourcePath);
            versionedResourcePath.append("-ver-").append(version);
        } else {
            versionedResourcePath.append(resourcePath.substring(0, extensionAt));
            versionedResourcePath.append("-ver-").append(version);
            versionedResourcePath.append(resourcePath.substring(extensionAt, resourcePath.length()));
        }
        log.trace("Inject version in resource path: '{}' => '{}'", (Object)resourcePath, (Object)versionedResourcePath);
        return versionedResourcePath.toString();
    }

    @Override
    public String removeVersion(String resourcePath) {
        Matcher matcher = VERSION_PATTERN.matcher(resourcePath);
        if (matcher.find()) {
            int startIndex = matcher.start() - 1;
            int endIndex = matcher.end() - 1;
            String version = resourcePath.substring(startIndex + 1, endIndex);
            String unversionedResourcePath = resourcePath.replace(version, "");
            log.trace("Remove version from resource path: '{}' => '{}'", (Object)resourcePath, (Object)unversionedResourcePath);
            return unversionedResourcePath;
        }
        return resourcePath;
    }

    protected void streamResource(URL resourceUrl, RouteContext routeContext) {
        try {
            long lastModified = resourceUrl.openConnection().getLastModified();
            ((Application)routeContext.getApplication()).getHttpCacheToolkit().addEtag(routeContext, lastModified);
            if (routeContext.getResponse().getStatus() == 304) {
                routeContext.getResponse().commit();
            } else {
                this.sendResource(resourceUrl, routeContext);
            }
        }
        catch (Exception e) {
            throw new PippoRuntimeException(e, "Failed to stream resource {}", resourceUrl);
        }
    }

    protected void sendResource(URL resourceUrl, RouteContext routeContext) throws IOException {
        String filename = resourceUrl.getFile();
        String mimeType = ((Application)routeContext.getApplication()).getMimeTypes().getContentType(filename);
        if (!StringUtils.isNullOrEmpty(mimeType)) {
            log.debug("Streaming as resource '{}'", (Object)resourceUrl);
            routeContext.getResponse().contentType(mimeType);
            routeContext.getResponse().ok().resource(resourceUrl.openStream());
        } else {
            log.debug("Streaming as file '{}'", (Object)resourceUrl);
            routeContext.getResponse().ok().file(filename, resourceUrl.openStream());
        }
    }
}

