/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class SettingsHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(SettingsHandler.class);
    private boolean maskingPassword = true;
    private String settingNamePasswordToken;

    public SettingsHandler() {
        this("password");
    }

    public SettingsHandler(boolean maskingPassword) {
        this.maskingPassword = maskingPassword;
    }

    public SettingsHandler(String settingNamePasswordToken) {
        this.settingNamePasswordToken = settingNamePasswordToken;
    }

    public void handle(RouteContext routeContext) {
        Map<String, String> settingsMap = this.settingsToMap(routeContext.getSettings());
        Response response = routeContext.getResponse().noCache().text();
        try (BufferedWriter writer = new BufferedWriter(response.getWriter());){
            this.writeSettings(settingsMap, writer);
            writer.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected Map<String, String> settingsToMap(PippoSettings settings) {
        List<String> settingNames = settings.getSettingNames();
        TreeMap<String, String> settingsMap = new TreeMap<String, String>();
        for (String settingName : settingNames) {
            settingsMap.put(settingName, settings.getRequiredString(settingName));
        }
        return settingsMap;
    }

    protected void writeSettings(Map<String, String> settings, BufferedWriter writer) throws IOException {
        TreeSet<String> names = new TreeSet<String>(settings.keySet());
        for (String name : names) {
            if (this.maskingPassword && name.contains(this.settingNamePasswordToken)) {
                writer.write(name + " = **********");
            } else {
                writer.write(name + " = " + settings.get(name));
            }
            writer.newLine();
        }
    }
}

