/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.UrlResourceHandler;

public class FileResourceHandler
extends UrlResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(FileResourceHandler.class);
    final String directory;

    public FileResourceHandler(String urlPath, File directory) {
        super(urlPath);
        this.directory = directory.getAbsolutePath();
    }

    public FileResourceHandler(String urlPath, String directory) {
        this(urlPath, new File(directory));
    }

    @Override
    public URL getResourceUrl(String resourcePath) {
        URL url = null;
        try {
            Path requestedPath = Paths.get(this.directory, resourcePath).normalize().toAbsolutePath();
            if (!requestedPath.startsWith(this.directory)) {
                log.warn("Request for '{}' which is not located in '{}'", (Object)requestedPath, (Object)this.directory);
                return null;
            }
            File file = requestedPath.toFile();
            if (file.exists() && file.isFile()) {
                url = requestedPath.toUri().toURL();
            } else {
                log.warn("File '{}' not found", (Object)resourcePath);
            }
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return url;
    }
}

