/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.StatusCodeException;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.util.CryptoUtils;
import ro.pippo.core.util.StringUtils;

public class CSRFHandler
implements RouteHandler<RouteContext> {
    public static final String TOKEN = "_csrf_token";
    public static final String BINDING = "csrfToken";
    private static final Logger log = LoggerFactory.getLogger(CSRFHandler.class);
    private final List<String> guardedTypes = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    private final String secretKey;
    private final String algorithm;

    public CSRFHandler() {
        this(CryptoUtils.generateSecretKey());
    }

    public CSRFHandler(String secretKey) {
        this(secretKey, "HmacSHA256");
    }

    public CSRFHandler(String secretKey, String algorithm) {
        this.secretKey = secretKey;
        this.algorithm = algorithm;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    protected String getSessionCsrfToken(RouteContext context) {
        return (String)context.getSession(TOKEN);
    }

    protected void setSessionCsrfToken(RouteContext context, String token) {
        context.setSession(TOKEN, token);
    }

    protected String getTokenId(RouteContext context) {
        return context.getSession().getId().toString();
    }

    @Override
    public void handle(RouteContext context) {
        String rawMethod = context.getRequest().getHttpServletRequest().getMethod();
        if ("POST".equals(rawMethod)) {
            String contentType = new ParameterValue(context.getRequest().getLocale(), context.getHeader("Content-Type")).toString("").toLowerCase();
            if (!this.guardedTypes.contains(contentType = StringUtils.getPrefix(contentType, ';').trim())) {
                log.debug("Ignoring '{}' request for {} '{}'", new Object[]{contentType, context.getRequestMethod(), context.getRequestUri()});
                return;
            }
            String requestToken = context.getHeader("Csrf-Token");
            if ("nocheck".equals(requestToken)) {
                log.debug("Ignoring 'nocheck' request for {} '{}'", (Object)context.getRequestMethod(), (Object)context.getRequestUri());
                return;
            }
            if (StringUtils.isNullOrEmpty(requestToken)) {
                requestToken = context.getParameter(TOKEN).toString();
            }
            if (StringUtils.isNullOrEmpty(requestToken)) {
                throw new StatusCodeException(403, "Illegal request, no '{}'!", TOKEN);
            }
            String sessionToken = this.getSessionCsrfToken(context);
            if (!requestToken.equals(sessionToken)) {
                throw new StatusCodeException(403, "Illegal request, invalid '{}'!", TOKEN);
            }
            log.debug("Validated '{}' for {} '{}'", new Object[]{TOKEN, context.getRequestMethod(), context.getRequestUri()});
            context.setLocal(BINDING, sessionToken);
        } else if ("GET".equals(rawMethod)) {
            if (this.getSessionCsrfToken(context) == null) {
                String sessionId = this.getTokenId(context);
                String token = CryptoUtils.hmacDigest(sessionId, this.secretKey, this.algorithm);
                this.setSessionCsrfToken(context, token);
                log.debug("Generated '{}' for {} '{}'", new Object[]{TOKEN, context.getRequestMethod(), context.getRequestUri()});
            }
            String token = this.getSessionCsrfToken(context);
            context.setLocal(BINDING, token);
        }
        context.next();
    }
}

