/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.reload;

import java.io.IOException;
import java.io.InputStream;
import ro.pippo.core.util.IoUtils;

public abstract class ReloadClassLoader
extends ClassLoader {
    private final String rootPackageName;

    public ReloadClassLoader(ClassLoader parentClassLoader, String rootPackageName) {
        super(parentClassLoader);
        if (rootPackageName == null) {
            throw new IllegalArgumentException("The 'rootPackageName' parameter is null");
        }
        this.rootPackageName = rootPackageName;
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.isTarget(className)) {
            String packageName;
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            int index = className.lastIndexOf(46);
            if (index >= 0 && this.getPackage(packageName = className.substring(0, index)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((clazz = this.defineClass(className, resolve)) != null) {
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    protected Class<?> defineClass(String className, boolean resolve) {
        String path = className.replace('.', '/') + ".class";
        InputStream is = this.getInputStream(path);
        if (is != null) {
            Class<?> clazz = this.defineClass(className, is);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return null;
    }

    protected Class<?> defineClass(String className, InputStream is) {
        try {
            return this.defineClass(className, IoUtils.getBytes(is));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Class<?> defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected abstract InputStream getInputStream(String var1);

    protected boolean isTarget(String className) {
        if (this.rootPackageName.isEmpty()) {
            return true;
        }
        return className.startsWith(this.rootPackageName + ".");
    }
}

