/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.gzip;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import ro.pippo.core.gzip.GZipResponseStream;
import ro.pippo.core.util.IoUtils;

public class GZipResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse response;
    private ServletOutputStream stream;
    private PrintWriter writer;

    public GZipResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, StandardCharsets.UTF_8));
        return this.writer;
    }

    public void setContentLength(int length) {
    }

    public void finish() {
        IoUtils.close(this.writer);
        IoUtils.close((Closeable)this.stream);
    }

    private ServletOutputStream createOutputStream() throws IOException {
        return new GZipResponseStream(this.response);
    }
}

