/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.gzip;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.pippo.core.gzip.GZipResponseWrapper;
import ro.pippo.core.util.StringUtils;

public class GZipFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.acceptsGZipEncoding(request)) {
            GZipResponseWrapper wrappedResponse = new GZipResponseWrapper(response);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
            wrappedResponse.finish();
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    protected boolean acceptsGZipEncoding(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("accept-encoding");
        return !StringUtils.isNullOrEmpty(acceptEncoding) && (acceptEncoding.contains("gzip") || acceptEncoding.contains("*"));
    }
}

