/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.Serializable;
import ro.pippo.core.PippoSettings;

public class WebServerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PORT = 8338;
    private String host = "localhost";
    private int port = 8338;
    private String contextPath = "/";
    private String keystoreFile;
    private String keystorePassword;
    private String truststoreFile;
    private String truststorePassword;

    public WebServerSettings(PippoSettings pippoSettings) {
        this.port = pippoSettings.getInteger("server.port", 8338);
        this.host = pippoSettings.getString("server.host", this.host);
        this.contextPath = pippoSettings.getString("server.contextPath", this.contextPath);
        this.keystoreFile = pippoSettings.getString("server.keystoreFile", this.keystoreFile);
        this.keystorePassword = pippoSettings.getString("server.keystorePassword", this.keystorePassword);
        this.truststoreFile = pippoSettings.getString("server.truststoreFile", this.truststoreFile);
        this.truststorePassword = pippoSettings.getString("server.truststorePassword", this.truststorePassword);
    }

    public String getHost() {
        return this.host;
    }

    public WebServerSettings host(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public WebServerSettings port(int port) {
        this.port = port;
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public WebServerSettings contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public WebServerSettings keystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public WebServerSettings keystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public WebServerSettings truststoreFile(String truststoreFile) {
        this.truststoreFile = truststoreFile;
        return this;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public WebServerSettings truststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }
}

