/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public enum RuntimeMode {
    DEV("dev"),
    TEST("test"),
    PROD("prod");

    private static RuntimeMode current;
    private final String name;
    private static final Map<String, RuntimeMode> map;

    private RuntimeMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RuntimeMode byName(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        throw new NoSuchElementException("Cannot found Pippo runtime mode with name '" + name + "'. Must be 'dev', 'test', or 'prod'.");
    }

    public static RuntimeMode getCurrent() {
        if (current == null) {
            String modeAsString = System.getProperty("pippo.mode", PROD.toString());
            current = RuntimeMode.byName(modeAsString);
        }
        return current;
    }

    static {
        map = new HashMap<String, RuntimeMode>();
        for (RuntimeMode mode : RuntimeMode.values()) {
            map.put(mode.name, mode);
        }
    }
}

