/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.ContentTypeEngines;
import ro.pippo.core.Flash;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Request;
import ro.pippo.core.ResponseFinalizeListenerList;
import ro.pippo.core.Session;
import ro.pippo.core.TemplateEngine;
import ro.pippo.core.gzip.GZipResponseWrapper;
import ro.pippo.core.route.RouteDispatcher;
import ro.pippo.core.util.DateUtils;
import ro.pippo.core.util.IoUtils;
import ro.pippo.core.util.MimeTypes;
import ro.pippo.core.util.StringUtils;

public final class Response {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private HttpServletResponse httpServletResponse;
    private ContentTypeEngines contentTypeEngines;
    private TemplateEngine templateEngine;
    private Map<String, Object> locals;
    private Map<String, String> headers;
    private Map<String, Cookie> cookies;
    private String contextPath;
    private String applicationPath;
    private ResponseFinalizeListenerList finalizeListeners;
    private MimeTypes mimeTypes;
    private int status;
    private boolean chunked;

    public Response(HttpServletResponse httpServletResponse, Application application) {
        this.httpServletResponse = httpServletResponse;
        this.contentTypeEngines = application.getContentTypeEngines();
        this.templateEngine = application.getTemplateEngine();
        this.httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.contextPath = application.getRouter().getContextPath();
        this.applicationPath = StringUtils.removeEnd(application.getRouter().getApplicationPath(), "/");
        this.mimeTypes = application.getMimeTypes();
        this.status = 0;
    }

    public Map<String, Object> getLocals() {
        if (this.locals == null) {
            this.locals = new HashMap<String, Object>();
        }
        return this.locals;
    }

    public Flash getFlash() {
        return (Flash)this.getLocals().get("flash");
    }

    public Response bind(String name, Object model) {
        this.getLocals().put(name, model);
        return this;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public String getCharacterEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    public Response characterEncoding(String charset) {
        this.checkCommitted();
        this.getHttpServletResponse().setCharacterEncoding(charset);
        return this;
    }

    private void addCookie(Cookie cookie) {
        this.checkCommitted();
        if (StringUtils.isNullOrEmpty(cookie.getPath())) {
            cookie.setPath(StringUtils.addStart(this.contextPath, "/"));
        }
        this.getCookieMap().put(cookie.getName(), cookie);
    }

    public Response cookie(Cookie cookie) {
        this.addCookie(cookie);
        return this;
    }

    public Response cookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(true);
        this.addCookie(cookie);
        return this;
    }

    public Response cookie(String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(true);
        cookie.setMaxAge(maxAge);
        this.addCookie(cookie);
        return this;
    }

    public Response cookie(String path, String domain, String name, String value, int maxAge, boolean secure) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secure);
        this.addCookie(cookie);
        return this;
    }

    public Collection<Cookie> getCookies() {
        return this.getCookieMap().values();
    }

    public Cookie getCookie(String name) {
        return this.getCookieMap().get(name);
    }

    public Response removeCookie(String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setSecure(true);
        cookie.setMaxAge(0);
        this.addCookie(cookie);
        return this;
    }

    private Map<String, Cookie> getCookieMap() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        return this.cookies;
    }

    private boolean isHeaderEmpty(String name) {
        return StringUtils.isNullOrEmpty(this.getHeaderMap().get(name));
    }

    public Response header(String name, String value) {
        this.checkCommitted();
        this.getHeaderMap().put(name, value);
        return this;
    }

    public Response header(String name, Date value) {
        this.checkCommitted();
        this.getHeaderMap().put(name, DateUtils.formatForHttpHeader(value));
        return this;
    }

    public Response filenameHeader(String filename) {
        if (filename != null && !filename.isEmpty()) {
            this.header("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        } else {
            this.header("Content-Disposition", "attachment; filename=\"\"");
        }
        return this;
    }

    public String getHeader(String name) {
        return this.getHeaderMap().get(name);
    }

    private Map<String, String> getHeaderMap() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public Response noCache() {
        this.checkCommitted();
        this.header("Cache-Control", "no-store, no-cache, must-revalidate");
        this.header("Cache-Control", "post-check=0, pre-check=0");
        this.header("Pragma", "no-cache");
        this.httpServletResponse.setDateHeader("Expires", 0L);
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Response status(int status) {
        this.checkCommitted();
        this.httpServletResponse.setStatus(status);
        this.status = status;
        return this;
    }

    public Response chunked() {
        return this.chunked(true);
    }

    public Response chunked(boolean chunked) {
        this.checkCommitted();
        this.chunked = chunked;
        return this;
    }

    public void redirect(String location) {
        this.checkCommitted();
        this.finalizeResponse();
        try {
            this.httpServletResponse.sendRedirect(location);
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public void redirectToContextPath(String path) {
        if ("".equals(this.contextPath)) {
            this.redirect(path);
        } else {
            this.redirect(this.contextPath + StringUtils.addStart(path, "/"));
        }
    }

    public void redirectToApplicationPath(String path) {
        if ("".equals(this.applicationPath)) {
            this.redirect(path);
        } else {
            this.redirect(this.applicationPath + StringUtils.addStart(path, "/"));
        }
    }

    public void redirect(String location, int statusCode) {
        this.checkCommitted();
        this.finalizeResponse();
        this.status(statusCode);
        this.header("Location", location);
        this.header("Connection", "close");
        try {
            this.httpServletResponse.sendError(statusCode);
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public Response ok() {
        this.status(200);
        return this;
    }

    public Response created() {
        this.status(201);
        return this;
    }

    public Response accepted() {
        this.status(202);
        return this;
    }

    public Response badRequest() {
        this.status(400);
        return this;
    }

    public Response unauthorized() {
        this.status(401);
        return this;
    }

    public Response paymentRequired() {
        this.status(402);
        return this;
    }

    public Response forbidden() {
        this.status(403);
        return this;
    }

    public Response notFound() {
        this.status(404);
        return this;
    }

    public Response methodNotAllowed() {
        this.status(405);
        return this;
    }

    public Response conflict() {
        this.status(409);
        return this;
    }

    public Response gone() {
        this.status(410);
        return this;
    }

    public Response internalError() {
        this.status(500);
        return this;
    }

    public Response notImplemented() {
        this.status(501);
        return this;
    }

    public Response overloaded() {
        this.status(502);
        return this;
    }

    public Response serviceUnavailable() {
        this.status(503);
        return this;
    }

    public Response contentLength(long length) {
        this.checkCommitted();
        this.httpServletResponse.setContentLength((int)length);
        return this;
    }

    public String getContentType() {
        String contentType = this.getHeader("Content-Type");
        if (contentType == null) {
            contentType = this.httpServletResponse.getContentType();
        }
        return contentType;
    }

    public Response contentType(String contentType) {
        this.checkCommitted();
        this.header("Content-Type", contentType);
        this.httpServletResponse.setContentType(contentType);
        return this;
    }

    public Response contentType(Request request) {
        if ("*/*".equals(request.getAcceptType())) {
            return this;
        }
        ContentTypeEngine engine = this.contentTypeEngines.getContentTypeEngine(request.getAcceptType());
        if (engine != null) {
            log.debug("Negotiated '{}' from request Accept header", (Object)engine.getContentType());
        } else if (!StringUtils.isNullOrEmpty(request.getContentType()) && (engine = this.contentTypeEngines.getContentTypeEngine(request.getContentType())) != null) {
            log.debug("Negotiated '{}' from request Content-Type header", (Object)engine.getContentType());
        }
        if (engine == null) {
            log.debug("Failed to negotiate a content type for Accept='{}' and Content-Type='{}'", (Object)request.getAcceptType(), (Object)request.getContentType());
            return this;
        }
        return this.contentType(engine.getContentType());
    }

    public Response text() {
        return this.contentType("text/plain");
    }

    public Response html() {
        return this.contentType("text/html");
    }

    public Response json() {
        return this.contentType("application/json");
    }

    public Response xml() {
        return this.contentType("application/xml");
    }

    public Response yaml() {
        return this.contentType("application/x-yaml");
    }

    public void send(CharSequence content) {
        this.checkCommitted();
        this.commit(content);
    }

    public void send(String format, Object ... args) {
        this.checkCommitted();
        this.commit(StringUtils.format(format, args));
    }

    public void json(Object object) {
        this.send(object, "application/json");
    }

    public void xml(Object object) {
        this.send(object, "application/xml");
    }

    public void yaml(Object object) {
        this.send(object, "application/x-yaml");
    }

    public void text(Object object) {
        this.send(object, "text/plain");
    }

    public void send(Object object) {
        if (object instanceof File) {
            this.file((File)object);
        } else {
            this.send(object, this.getContentType());
        }
    }

    private void send(Object object, String contentType) {
        if (StringUtils.isNullOrEmpty(contentType)) {
            throw new PippoRuntimeException("You must specify a content type!", new Object[0]);
        }
        ContentTypeEngine contentTypeEngine = this.contentTypeEngines.getContentTypeEngine(contentType);
        if (contentTypeEngine == null) {
            throw new PippoRuntimeException("You must set a content type engine for '{}'", contentType);
        }
        this.header("Content-Type", contentTypeEngine.getContentType());
        this.send(contentTypeEngine.toString(object));
    }

    public void resource(InputStream input) {
        this.checkCommitted();
        this.finalizeResponse();
        if (this.getContentType() == null) {
            this.contentType("application/octet-stream");
        }
        try {
            this.send(input);
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public void file(File file) {
        try {
            this.contentLength(file.length());
            this.file(file.getName(), new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public void file(String filename, InputStream input) {
        this.checkCommitted();
        if (this.getContentType() == null) {
            this.contentType(this.mimeTypes.getContentType(filename, "application/octet-stream"));
        }
        if (this.isHeaderEmpty("Content-Disposition")) {
            this.filenameHeader(filename);
        }
        this.finalizeResponse();
        try {
            this.send(input);
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    private void send(InputStream input) throws IOException {
        try {
            IoUtils.copy(input, (OutputStream)this.httpServletResponse.getOutputStream());
            if (this.chunked) {
                this.httpServletResponse.flushBuffer();
            }
        }
        finally {
            IoUtils.close(input);
        }
    }

    public void render(String templateName) {
        this.render(templateName, new HashMap<String, Object>());
    }

    public void render(String templateName, Map<String, Object> model) {
        this.send(this.renderToString(templateName, model));
    }

    public String renderToString(String templateName) {
        return this.renderToString(templateName, new HashMap<String, Object>());
    }

    public String renderToString(String templateName, Map<String, Object> model) {
        if (this.templateEngine == null) {
            throw new PippoRuntimeException("You must set a template engine in your application", new Object[0]);
        }
        model.putAll(this.getLocals());
        Session session = Session.get();
        if (session != null) {
            model.put("session", session);
        }
        StringWriter stringWriter = new StringWriter();
        this.templateEngine.renderResource(templateName, model, stringWriter);
        return stringWriter.toString();
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new PippoRuntimeException("The response has already been committed", new Object[0]);
        }
    }

    public boolean isCommitted() {
        return this.httpServletResponse.isCommitted();
    }

    public void commit() {
        this.commit(null);
    }

    private void commit(CharSequence content) {
        this.checkCommitted();
        this.finalizeResponse();
        if (this.getContentType() == null) {
            this.contentType("text/html");
        }
        try {
            if (content != null) {
                this.contentLength(content.toString().getBytes().length);
                this.httpServletResponse.getWriter().append(content);
            }
            log.trace("Response committed");
            if (this.chunked) {
                this.httpServletResponse.flushBuffer();
            }
            this.finishGZip();
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    private void finalizeResponse() {
        for (Map.Entry<String, String> header : this.getHeaderMap().entrySet()) {
            this.httpServletResponse.setHeader(header.getKey(), header.getValue());
        }
        for (Cookie cookie : this.getCookies()) {
            this.httpServletResponse.addCookie(cookie);
        }
        if (this.getStatus() == 0 || this.getStatus() == Integer.MAX_VALUE) {
            this.ok();
        }
        if (this.finalizeListeners != null && !this.finalizeListeners.isEmpty()) {
            this.finalizeListeners.onFinalize(this);
        }
    }

    private void finishGZip() {
        if (this.httpServletResponse instanceof GZipResponseWrapper) {
            GZipResponseWrapper responseWrapper = (GZipResponseWrapper)this.httpServletResponse;
            responseWrapper.finish();
        }
    }

    public ResponseFinalizeListenerList getFinalizeListeners() {
        if (this.finalizeListeners == null) {
            this.finalizeListeners = new ResponseFinalizeListenerList();
        }
        return this.finalizeListeners;
    }

    public ServletOutputStream getOutputStream() {
        this.checkCommitted();
        this.finalizeResponse();
        if (this.getContentType() == null) {
            this.contentType("application/octet-stream");
        }
        try {
            return this.httpServletResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public PrintWriter getWriter() {
        this.checkCommitted();
        this.finalizeResponse();
        if (this.getContentType() == null) {
            this.contentType("text/html");
        }
        try {
            return this.httpServletResponse.getWriter();
        }
        catch (IOException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public void reset() {
        this.checkCommitted();
        this.headers = new HashMap<String, String>();
        this.cookies = new HashMap<String, Cookie>();
        this.locals = new HashMap<String, Object>();
        this.status = 0;
        try {
            this.httpServletResponse.reset();
        }
        catch (Exception e) {
            throw new PippoRuntimeException(e);
        }
    }

    public static Response get() {
        Object routeContext = RouteDispatcher.getRouteContext();
        return routeContext != null ? routeContext.getResponse() : null;
    }
}

