/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.ContentTypeEngines;
import ro.pippo.core.FileItem;
import ro.pippo.core.Flash;
import ro.pippo.core.ParamField;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Session;
import ro.pippo.core.route.RouteDispatcher;
import ro.pippo.core.util.ClassUtils;
import ro.pippo.core.util.CookieUtils;
import ro.pippo.core.util.IoUtils;
import ro.pippo.core.util.StringUtils;

public final class Request {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private HttpServletRequest httpServletRequest;
    private ContentTypeEngines contentTypeEngines;
    private Map<String, ParameterValue> parameters;
    private Map<String, ParameterValue> pathParameters;
    private Map<String, ParameterValue> allParameters;
    private Map<String, FileItem> files;
    private Session session;
    private String applicationPath;
    private String method;
    private String path;
    private String acceptType;
    private String contentType;
    private String body;

    public Request(HttpServletRequest servletRequest, Application application) {
        this.httpServletRequest = servletRequest;
        this.contentTypeEngines = application.getContentTypeEngines();
        this.applicationPath = application.getRouter().getApplicationPath();
        this.initParameters();
        this.pathParameters = Collections.unmodifiableMap(new HashMap());
        this.initAllParameters();
    }

    public Map<String, ParameterValue> getParameters() {
        return this.allParameters;
    }

    public ParameterValue getParameter(String name) {
        if (!this.getParameters().containsKey(name)) {
            return this.buildParameterValue(new String[0]);
        }
        return this.getParameters().get(name);
    }

    public Map<String, ParameterValue> getQueryParameters() {
        return this.parameters;
    }

    public ParameterValue getQueryParameter(String name) {
        if (!this.getQueryParameters().containsKey(name)) {
            return this.buildParameterValue(new String[0]);
        }
        return this.getQueryParameters().get(name);
    }

    public Map<String, ParameterValue> getPathParameters() {
        return this.pathParameters;
    }

    public ParameterValue getPathParameter(String name) {
        if (!this.getPathParameters().containsKey(name)) {
            return this.buildParameterValue(new String[0]);
        }
        return this.getPathParameters().get(name);
    }

    private void initParameters() {
        HashMap arrays = new HashMap();
        HashMap<String, ParameterValue> tmp = new HashMap<String, ParameterValue>();
        Enumeration names = this.httpServletRequest.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.matches("(.+)\\[(\\d+)\\]")) {
                int brk = name.indexOf(91);
                String base = name.substring(0, brk);
                try {
                    int idx = Integer.parseInt(name.substring(brk + 1, name.length() - 1));
                    if (!arrays.containsKey(base)) {
                        arrays.put(base, new TreeMap());
                    }
                    Map map = (Map)arrays.get(base);
                    String value = this.httpServletRequest.getParameterValues(name)[0];
                    map.put(idx, value);
                }
                catch (NumberFormatException e) {
                    String[] values = this.httpServletRequest.getParameterValues(name);
                    tmp.put(name, this.buildParameterValue(values));
                }
                continue;
            }
            String[] values = this.httpServletRequest.getParameterValues(name);
            tmp.put(name, this.buildParameterValue(values));
        }
        for (Map.Entry entry : arrays.entrySet()) {
            int maxIndex = 0;
            Iterator e = ((Map)entry.getValue()).keySet().iterator();
            while (e.hasNext()) {
                int index = (Integer)e.next();
                if (index <= maxIndex) continue;
                maxIndex = index;
            }
            String[] values = new String[maxIndex + 1];
            for (Map.Entry indexedValue : ((Map)entry.getValue()).entrySet()) {
                values[((Integer)indexedValue.getKey()).intValue()] = (String)indexedValue.getValue();
            }
            tmp.put((String)entry.getKey(), this.buildParameterValue(values));
        }
        this.parameters = Collections.unmodifiableMap(tmp);
    }

    private void initPathParameters(Map<String, String> map) {
        HashMap<String, ParameterValue> tmp = new HashMap<String, ParameterValue>();
        if (map != null) {
            Set<String> names = map.keySet();
            for (String name : names) {
                tmp.put(name, this.buildParameterValue(map.get(name)));
            }
        }
        this.pathParameters = Collections.unmodifiableMap(tmp);
    }

    private void initAllParameters() {
        HashMap<String, ParameterValue> tmp = new HashMap<String, ParameterValue>();
        tmp.putAll(this.parameters);
        tmp.putAll(this.pathParameters);
        this.allParameters = Collections.unmodifiableMap(tmp);
    }

    public void internalSetPathParameters(Map<String, String> pathParameters) {
        this.initPathParameters(pathParameters);
        this.initAllParameters();
    }

    public <T> T createEntityFromParameters(Class<T> entityClass) {
        T entity;
        try {
            entity = entityClass.newInstance();
        }
        catch (Exception e) {
            log.error("Cannot create new instance of class '{}'", (Object)entityClass.getName(), (Object)e);
            return null;
        }
        this.updateEntityFromParameters(entity);
        return entity;
    }

    public <T, X> T updateEntityFromParameters(T entity) {
        for (Field field : ClassUtils.getAllFields(entity.getClass())) {
            String parameterName = field.getName();
            ParamField parameter = field.getAnnotation(ParamField.class);
            if (parameter != null) {
                parameterName = parameter.value();
            }
            if (!this.getParameters().containsKey(parameterName)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            String pattern = parameter != null ? parameter.pattern() : null;
            Class converterClass = parameter != null && Void.TYPE != parameter.converterClass() ? parameter.converterClass() : null;
            try {
                Object value;
                Class<?> fieldClass = field.getType();
                if (converterClass == null) {
                    if (Collection.class.isAssignableFrom(fieldClass)) {
                        Class genericClass;
                        Type parameterType = field.getGenericType();
                        if (!ParameterizedType.class.isAssignableFrom(parameterType.getClass())) {
                            throw new PippoRuntimeException("Please specify a generic parameter type for field '{}' {}", field.getName(), fieldClass.getName());
                        }
                        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
                        try {
                            genericClass = (Class)parameterizedType.getActualTypeArguments()[0];
                        }
                        catch (ClassCastException e) {
                            throw new PippoRuntimeException("Please specify a generic parameter type for field '{}' {}", field.getName(), fieldClass.getName());
                        }
                        if (Set.class == fieldClass) {
                            value = this.getParameters().get(parameterName).toSet(genericClass, pattern);
                        } else if (List.class == fieldClass) {
                            value = this.getParameters().get(parameterName).toList(genericClass, pattern);
                        } else {
                            if (fieldClass.isInterface()) {
                                throw new PippoRuntimeException("Field '{}' collection '{}' is not a supported type!", field.getName(), fieldClass.getName());
                            }
                            Class<?> collectionClass = fieldClass;
                            value = this.getParameters().get(parameterName).toCollection(collectionClass, genericClass, pattern);
                        }
                    } else {
                        value = this.getParameters().get(parameterName).to(fieldClass, pattern);
                    }
                } else {
                    value = this.getParameters().get(parameterName).convert(converterClass, pattern);
                }
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                log.error("Cannot set value for field '{}' from parameter '{}'", new Object[]{field.getName(), parameterName, e});
            }
            catch (PippoRuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    public <T> T createEntityFromBody(Class<T> entityClass) {
        try {
            String body = this.getBody();
            if (StringUtils.isNullOrEmpty(body)) {
                log.warn("Can not create entity '{}' from null or empty request body!", (Object)entityClass.getName());
                return null;
            }
            String contentType = this.getContentType();
            if (StringUtils.isNullOrEmpty(contentType)) {
                contentType = this.getAcceptType();
            }
            if (StringUtils.isNullOrEmpty(contentType)) {
                throw new PippoRuntimeException("Failed to create entity '{}' from request body because 'content-type' is not specified!", entityClass.getName());
            }
            ContentTypeEngine engine = this.contentTypeEngines.getContentTypeEngine(contentType);
            if (engine == null) {
                throw new PippoRuntimeException("Failed to create entity '{}' from request body because a content engine for '{}' could not be found!", entityClass.getName(), contentType);
            }
            return engine.fromString(body, entityClass);
        }
        catch (PippoRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PippoRuntimeException(e, "Failed to create entity '{}' from request body!", entityClass.getName());
        }
    }

    public String getHost() {
        return this.httpServletRequest.getHeader("Host");
    }

    public String getUserAgent() {
        return this.httpServletRequest.getHeader("User-Agent");
    }

    public int getPort() {
        return this.httpServletRequest.getServerPort();
    }

    public String getClientIp() {
        return this.httpServletRequest.getRemoteAddr();
    }

    public int getContentLength() {
        return this.httpServletRequest.getContentLength();
    }

    public String getScheme() {
        return this.httpServletRequest.getScheme();
    }

    public String getAcceptType() {
        if (this.acceptType == null) {
            ContentTypeEngine engine;
            this.acceptType = this.httpServletRequest.getHeader("Accept");
            String suffix = StringUtils.getFileExtension(this.getPath());
            if (!StringUtils.isNullOrEmpty(suffix) && (engine = this.contentTypeEngines.getContentTypeEngine(suffix)) != null) {
                this.acceptType = engine.getContentType();
            }
        }
        return this.acceptType;
    }

    public String getContentType() {
        if (this.contentType == null) {
            String httpServletRequestContentType = this.httpServletRequest.getHeader("Content-Type");
            this.contentType = "POST".equals(this.httpServletRequest.getMethod()) && ("application/x-www-form-urlencoded".equals(httpServletRequestContentType) || "multipart/form-data".equals(httpServletRequestContentType)) ? this.getParameter("_content_type").toString(httpServletRequestContentType) : httpServletRequestContentType;
        }
        return this.contentType;
    }

    public Locale getLocale() {
        return this.httpServletRequest.getLocale();
    }

    public String getBody() {
        if (this.body == null) {
            String httpServletRequestContentType = this.httpServletRequest.getHeader("Content-Type");
            if ("POST".equals(this.httpServletRequest.getMethod()) && ("application/x-www-form-urlencoded".equals(httpServletRequestContentType) || "multipart/form-data".equals(httpServletRequestContentType))) {
                this.body = this.getParameter("_content").toString(null);
            } else {
                try {
                    this.body = IoUtils.toString((InputStream)this.httpServletRequest.getInputStream());
                }
                catch (Exception e) {
                    throw new PippoRuntimeException(e, "Exception when reading the request body", new Object[0]);
                }
            }
        }
        return this.body;
    }

    public String getHeader(String name) {
        return this.httpServletRequest.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.httpServletRequest.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.httpServletRequest.getHeaderNames();
    }

    public boolean isSecure() {
        return this.httpServletRequest.isSecure();
    }

    public String getUrl() {
        return this.httpServletRequest.getRequestURL().toString();
    }

    public String getUri() {
        return this.httpServletRequest.getRequestURI();
    }

    public String getQuery() {
        return this.httpServletRequest.getQueryString();
    }

    public String getApplicationUri() {
        if ("".equals(this.applicationPath)) {
            return this.getUri();
        }
        return this.getUri().substring(this.applicationPath.length());
    }

    public String getApplicationUriWithQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getApplicationUri());
        if (this.getQuery() != null) {
            sb.append('?').append(this.getQuery());
        }
        return sb.toString();
    }

    public String getContextPath() {
        return this.httpServletRequest.getContextPath();
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public String getPath() {
        if (this.path == null) {
            URI uri = URI.create(this.httpServletRequest.getRequestURL().toString());
            String requestUri = uri.getPath();
            String string = this.path = this.applicationPath.isEmpty() ? requestUri : requestUri.substring(this.applicationPath.length());
            if (StringUtils.isNullOrEmpty(this.path)) {
                this.path = "/";
            }
        }
        return this.path;
    }

    public String getMethod() {
        if (this.method == null) {
            String httpServletRequestMethod = this.httpServletRequest.getMethod();
            String httpServletRequestContentType = this.httpServletRequest.getHeader("Content-Type");
            this.method = "POST".equals(httpServletRequestMethod) && ("application/x-www-form-urlencoded".equals(httpServletRequestContentType) || "multipart/form-data".equals(httpServletRequestContentType)) ? this.getParameter("_method").toString(httpServletRequestMethod).toUpperCase() : httpServletRequestMethod;
        }
        return this.method;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean create) {
        HttpSession httpSession;
        if (this.session == null && (httpSession = this.httpServletRequest.getSession(create)) != null) {
            this.session = new Session(httpSession);
        }
        return this.session;
    }

    public void resetSession() {
        if (this.session == null) {
            return;
        }
        this.session.invalidate();
        this.session = null;
        this.getSession();
    }

    public void recreateSession() {
        if (this.session == null) {
            return;
        }
        HashMap values = new HashMap();
        Enumeration<String> names = this.getSession().getNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            values.put(name, this.getSession().get(name));
        }
        Flash flash = this.session.getFlash();
        this.resetSession();
        for (Map.Entry entry : values.entrySet()) {
            this.getSession().put((String)entry.getKey(), entry.getValue());
        }
        if (flash != null) {
            this.getSession().put("flash", flash);
        }
    }

    public Map<String, FileItem> getFiles() {
        if (this.files == null) {
            this.files = new HashMap<String, FileItem>();
            try {
                Collection parts = this.httpServletRequest.getParts();
                for (Part part : parts) {
                    this.files.put(part.getName(), new FileItem(part));
                }
            }
            catch (Exception e) {
                throw new PippoRuntimeException(e, "Cannot get files", new Object[0]);
            }
        }
        return this.files;
    }

    public FileItem getFile(String name) {
        return this.getFiles().get(name);
    }

    public List<Cookie> getCookies() {
        return CookieUtils.getCookies(this.httpServletRequest);
    }

    public Cookie getCookie(String name) {
        return CookieUtils.getCookie(this.httpServletRequest, name);
    }

    public static Request get() {
        Object routeContext = RouteDispatcher.getRouteContext();
        return routeContext != null ? routeContext.getRequest() : null;
    }

    private ParameterValue buildParameterValue(String ... values) {
        return new ParameterValue(this.getLocale(), values);
    }

    public String toString() {
        return "Request{requestMethod='" + this.getMethod() + '\'' + ", uriPattern='" + this.getApplicationUri() + '\'' + '}';
    }
}

