/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Languages;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.ClasspathUtils;
import ro.pippo.core.util.StringUtils;

public class Messages {
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private final Map<String, Properties> languageMessages;
    private final Languages languages;

    public Messages(Languages languages) {
        this.languages = languages;
        this.languageMessages = this.loadRegisteredMessageResources();
    }

    public String get(String key, RouteContext routeContext, Object ... args) {
        String language = this.languages.getLanguageOrDefault(routeContext);
        return this.get(key, language, args);
    }

    public String get(String key, String language, Object ... args) {
        Properties messages = this.getMessagesForLanguage(language);
        String value = messages.getProperty(key);
        if (value != null) {
            return this.formatMessage(value, language, args);
        }
        log.warn("Failed to find '{}' in Messages", (Object)key);
        return key;
    }

    public String getWithDefault(String key, String defaultMessage, RouteContext routeContext, Object ... args) {
        String language = this.languages.getLanguageOrDefault(routeContext);
        return this.getWithDefault(key, defaultMessage, language, args);
    }

    public String getWithDefault(String key, String defaultMessage, String language, Object ... args) {
        String value = this.get(key, language, args);
        if (value.equals(key)) {
            value = this.formatMessage(defaultMessage, language, args);
        }
        return value;
    }

    public Map<String, String> getAll(RouteContext routeContext) {
        String language = this.languages.getLanguageOrDefault(routeContext);
        return this.getAll(language);
    }

    public Map<String, String> getAll(String language) {
        Properties messages = this.getMessagesForLanguage(language);
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : messages.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return map;
    }

    private Map<String, Properties> loadRegisteredMessageResources() {
        Map<String, Properties> internalMessages = this.loadRegisteredMessageResources("pippo/pippo-messages%s.properties");
        Map<String, Properties> applicationMessages = this.loadRegisteredMessageResources("conf/messages%s.properties");
        TreeMap<String, Properties> allMessages = new TreeMap<String, Properties>();
        HashSet<String> merged = new HashSet<String>();
        for (Map.Entry<String, Properties> entry : internalMessages.entrySet()) {
            String language = entry.getKey();
            Properties messages = entry.getValue();
            allMessages.put(language, messages);
            if (applicationMessages.containsKey(language)) {
                messages.putAll((Map<?, ?>)applicationMessages.get(language));
            }
            merged.add(language);
        }
        HashSet<String> unmerged = new HashSet<String>(applicationMessages.keySet());
        unmerged.removeAll(merged);
        for (String language : unmerged) {
            allMessages.put(language, applicationMessages.get(language));
        }
        return allMessages;
    }

    private Map<String, Properties> loadRegisteredMessageResources(String name) {
        TreeMap<String, Properties> messageResources = new TreeMap<String, Properties>();
        Properties defaultMessages = this.loadMessages(String.format(name, ""));
        if (defaultMessages == null) {
            log.error("Could not locate the default messages resource '{}', please create it.", (Object)String.format(name, ""));
        } else {
            messageResources.put("", defaultMessages);
        }
        List<String> registeredLanguages = this.languages.getRegisteredLanguages();
        for (String language : registeredLanguages) {
            Properties messages = this.loadMessages(String.format(name, "_" + language));
            Properties messagesLangOnly = null;
            String langComponent = this.languages.getLanguageComponent(language);
            if (!langComponent.equals(language) && (messagesLangOnly = (Properties)messageResources.get(langComponent)) == null) {
                messagesLangOnly = this.loadMessages(String.format(name, "_" + langComponent));
            }
            if (messages == null) {
                log.error("Could not locate the '{}' messages resource '{}' specified in '{}'.", new Object[]{language, String.format(name, "_" + language), "application.languages"});
                continue;
            }
            Properties compositeMessages = new Properties(defaultMessages);
            if (messagesLangOnly != null) {
                compositeMessages.putAll((Map<?, ?>)messagesLangOnly);
                if (!messageResources.containsKey(langComponent)) {
                    Properties langResources = new Properties();
                    langResources.putAll((Map<?, ?>)compositeMessages);
                    messageResources.put(langComponent, langResources);
                }
            }
            compositeMessages.putAll((Map<?, ?>)messages);
            messageResources.put(language.toLowerCase(), compositeMessages);
        }
        return Collections.unmodifiableMap(messageResources);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadMessages(String fileOrUrl) {
        URL url = ClasspathUtils.locateOnClasspath(fileOrUrl);
        if (url == null) return null;
        try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
            Properties messages = new Properties();
            messages.load(reader);
            Properties properties = messages;
            return properties;
        }
        catch (IOException e) {
            log.error("Failed to load {}", (Object)fileOrUrl, (Object)e);
        }
        return null;
    }

    private Properties getMessagesForLanguage(String language) {
        if (StringUtils.isNullOrEmpty(language)) {
            return this.languageMessages.get("");
        }
        String supportedLanguage = this.languages.getLanguageOrDefault(language);
        if (StringUtils.isNullOrEmpty(supportedLanguage)) {
            log.debug("Messages for '{}' were requested. Using default messages.", (Object)language);
            return this.languageMessages.get("");
        }
        Properties messages = this.languageMessages.get(supportedLanguage);
        if (messages != null) {
            return messages;
        }
        String langComponent = this.languages.getLanguageComponent(supportedLanguage);
        messages = this.languageMessages.get(langComponent);
        if (messages != null) {
            return messages;
        }
        return this.languageMessages.get("");
    }

    private String formatMessage(String message, String language, Object ... args) {
        if (args != null && args.length > 0) {
            Locale locale = this.languages.getLocaleOrDefault(language);
            MessageFormat messageFormat = new MessageFormat(message, locale);
            return messageFormat.format(args);
        }
        return message;
    }
}

