/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoConstants;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.UriMatcher;

public class DefaultUriMatcher
implements UriMatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultUriMatcher.class);
    private static final Pattern PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE = Pattern.compile("\\{(.*?)(:\\s(.*?))?\\}");
    private static final String VARIABLE_ROUTES_DEFAULT_REGEX = "(?<%s>[^/]+)";
    private static final String VARIABLE_PART_PATTERN_WITH_PLACEHOLDER = "\\{(%s)(:\\s([^}]*))?\\}";
    private static final String PATH_PARAMETER_REGEX_GROUP_NAME_PREFIX = "param";
    private Map<String, UriMatcher.UriPatternBinding> bindings = new HashMap<String, UriMatcher.UriPatternBinding>();

    @Override
    public Map<String, String> match(String requestUri, String uriPattern) {
        UriMatcher.UriPatternBinding binding = this.bindings.get(uriPattern);
        if (binding == null) {
            throw new PippoRuntimeException("No binding for '{}'. Create binding with 'addUriPattern'.", uriPattern);
        }
        return binding.getPattern().matcher(requestUri).matches() ? this.getParameters(binding, requestUri) : null;
    }

    @Override
    public UriMatcher.UriPatternBinding addUriPattern(String uriPattern) {
        if (this.bindings.containsKey(uriPattern)) {
            return this.bindings.get(uriPattern);
        }
        String regex = this.getRegex(uriPattern);
        Pattern pattern = Pattern.compile(regex);
        List<String> parameterNames = this.getParameterNames(uriPattern);
        UriMatcher.UriPatternBinding binding = new UriMatcher.UriPatternBinding(uriPattern, pattern, parameterNames);
        this.bindings.put(uriPattern, binding);
        log.trace("Add binding '{}'", (Object)binding);
        return binding;
    }

    @Override
    public UriMatcher.UriPatternBinding removeUriPattern(String uriPattern) {
        return this.bindings.remove(uriPattern);
    }

    @Override
    public String uriFor(String uriPattern, Map<String, Object> parameters) {
        UriMatcher.UriPatternBinding binding = this.bindings.get(uriPattern);
        if (binding == null) {
            throw new PippoRuntimeException("No binding for '{}'. Create binding with 'addUriPattern'.", uriPattern);
        }
        List<String> parameterNames = binding.getParameterNames();
        if (!parameters.keySet().containsAll(parameterNames)) {
            log.error("You must provide values for all path parameters. {} vs {}", parameterNames, parameters.keySet());
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>(parameters.size());
        String uri = binding.getUriPattern();
        for (Map.Entry<String, Object> parameterPair : parameters.entrySet()) {
            boolean foundAsPathParameter = false;
            StringBuffer sb = new StringBuffer();
            String regex = String.format(VARIABLE_PART_PATTERN_WITH_PLACEHOLDER, parameterPair.getKey());
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(uri);
            while (matcher.find()) {
                matcher.appendReplacement(sb, this.getPathParameterValue(uriPattern, parameterPair.getKey(), parameterPair.getValue()));
                foundAsPathParameter = true;
            }
            matcher.appendTail(sb);
            uri = sb.toString();
            if (foundAsPathParameter) continue;
            queryParameters.put(parameterPair.getKey(), parameterPair.getValue());
        }
        if (!queryParameters.isEmpty()) {
            StringBuilder query = new StringBuilder();
            Iterator iterator = queryParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                String encodedParameterValue;
                Map.Entry parameterEntry = iterator.next();
                String parameterName = (String)parameterEntry.getKey();
                Object parameterValue = parameterEntry.getValue();
                try {
                    encodedParameterValue = URLEncoder.encode(parameterValue.toString(), PippoConstants.UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new PippoRuntimeException(e, "Cannot encode the parameter value '{}'", parameterValue.toString());
                }
                query.append(parameterName).append("=").append(encodedParameterValue);
                if (!iterator.hasNext()) continue;
                query.append("&");
            }
            uri = uri + "?" + query;
        }
        return uri;
    }

    protected String getPathParameterValue(String uriPattern, String parameterName, Object parameterValue) {
        return parameterValue.toString();
    }

    private Map<String, String> getParameters(UriMatcher.UriPatternBinding binding, String requestUri) {
        List<String> parameterNames = binding.getParameterNames();
        if (parameterNames.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Matcher matcher = binding.getPattern().matcher(requestUri);
        matcher.matches();
        int groupCount = matcher.groupCount();
        if (groupCount > 0) {
            for (int i = 0; i < parameterNames.size(); ++i) {
                parameters.put(parameterNames.get(i), matcher.group(this.getPathParameterRegexGroupName(i)));
            }
        }
        return parameters;
    }

    private String getRegex(String urlPattern) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(urlPattern);
        int pathParameterIndex = 0;
        while (matcher.find()) {
            String namedVariablePartOfORouteReplacedWithRegex;
            String namedVariablePartOfRoute = matcher.group(3);
            if (namedVariablePartOfRoute != null) {
                String variableRegex = this.replacePosixClasses(namedVariablePartOfRoute);
                namedVariablePartOfORouteReplacedWithRegex = String.format("(?<%s>%s)", this.getPathParameterRegexGroupName(pathParameterIndex), Matcher.quoteReplacement(variableRegex));
            } else {
                namedVariablePartOfORouteReplacedWithRegex = String.format(VARIABLE_ROUTES_DEFAULT_REGEX, this.getPathParameterRegexGroupName(pathParameterIndex));
            }
            matcher.appendReplacement(buffer, namedVariablePartOfORouteReplacedWithRegex);
            ++pathParameterIndex;
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String getPathParameterRegexGroupName(int pathParameterIndex) {
        return PATH_PARAMETER_REGEX_GROUP_NAME_PREFIX + pathParameterIndex;
    }

    private String replacePosixClasses(String input) {
        return input.replace(":alnum:", "\\p{Alnum}").replace(":alpha:", "\\p{L}").replace(":ascii:", "\\p{ASCII}").replace(":digit:", "\\p{Digit}").replace(":xdigit:", "\\p{XDigit}");
    }

    private List<String> getParameterNames(String uriPattern) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = PATTERN_FOR_VARIABLE_PARTS_OF_ROUTE.matcher(uriPattern);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

