/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.ContentTypeEngines;
import ro.pippo.core.DefaultErrorHandler;
import ro.pippo.core.ErrorHandler;
import ro.pippo.core.Initializer;
import ro.pippo.core.Languages;
import ro.pippo.core.Messages;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.RequestResponseFactory;
import ro.pippo.core.RuntimeMode;
import ro.pippo.core.TemplateEngine;
import ro.pippo.core.TextPlainEngine;
import ro.pippo.core.gzip.GZipRequestResponseFactory;
import ro.pippo.core.route.DefaultRouter;
import ro.pippo.core.route.ResourceRouting;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteDispatcher;
import ro.pippo.core.route.RouteGroup;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.route.RoutePostDispatchListenerList;
import ro.pippo.core.route.RoutePreDispatchListenerList;
import ro.pippo.core.route.RouteTransformer;
import ro.pippo.core.route.Router;
import ro.pippo.core.util.HttpCacheToolkit;
import ro.pippo.core.util.MimeTypes;
import ro.pippo.core.util.ServiceLocator;
import ro.pippo.core.websocket.WebSocketHandler;
import ro.pippo.core.websocket.WebSocketRouter;

public class Application
implements ResourceRouting {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private PippoSettings pippoSettings;
    private Languages languages;
    private Messages messages;
    private MimeTypes mimeTypes;
    private HttpCacheToolkit httpCacheToolkit;
    private TemplateEngine templateEngine;
    private ContentTypeEngines engines;
    protected Router router;
    private ErrorHandler errorHandler;
    private RequestResponseFactory requestResponseFactory;
    private ServletContext servletContext;
    private List<Initializer> initializers;
    private String uploadLocation = System.getProperty("java.io.tmpdir");
    private long maximumUploadSize = -1L;
    private RoutePreDispatchListenerList routePreDispatchListeners;
    private RoutePostDispatchListenerList routePostDispatchListeners;
    private Map<String, Object> locals;
    private RouteHandler notFoundRouteHandler;
    private WebSocketRouter webSocketRouter;

    public Application() {
        this(new PippoSettings(RuntimeMode.getCurrent()));
    }

    public Application(PippoSettings settings) {
        this.pippoSettings = settings;
        this.languages = new Languages(settings);
        this.messages = new Messages(this.languages);
        this.mimeTypes = new MimeTypes(settings);
        this.httpCacheToolkit = new HttpCacheToolkit(settings);
        this.engines = new ContentTypeEngines();
        this.initializers = new ArrayList<Initializer>();
        this.webSocketRouter = new WebSocketRouter();
        this.registerContentTypeEngine(TextPlainEngine.class);
    }

    public final void init() {
        this.initializers.addAll(ServiceLocator.locateAll(Initializer.class));
        for (Initializer initializer : this.initializers) {
            log.debug("Initializing '{}'", (Object)initializer.getClass().getName());
            try {
                initializer.init(this);
            }
            catch (Exception e) {
                log.error("Failed to initialize '{}'", (Object)initializer.getClass().getName(), (Object)e);
            }
        }
        List<RouteTransformer> transformers = ServiceLocator.locateAll(RouteTransformer.class);
        for (RouteTransformer transformer : transformers) {
            this.getRouter().addRouteTransformer(transformer);
        }
        this.onInit();
        this.getRouter().compileRoutes();
    }

    public final void destroy() {
        this.onDestroy();
        for (Initializer initializer : this.initializers) {
            log.debug("Destroying '{}'", (Object)initializer.getClass().getName());
            try {
                initializer.destroy(this);
            }
            catch (Exception e) {
                log.error("Failed to destroy '{}'", (Object)initializer.getClass().getName(), (Object)e);
            }
        }
    }

    protected void onInit() {
    }

    protected void onDestroy() {
    }

    public RuntimeMode getRuntimeMode() {
        return this.pippoSettings.getRuntimeMode();
    }

    public PippoSettings getPippoSettings() {
        return this.pippoSettings;
    }

    public String getApplicationName() {
        return this.pippoSettings.getString("application.name", "");
    }

    public String getApplicationVersion() {
        return this.pippoSettings.getString("application.version", "");
    }

    public Languages getLanguages() {
        return this.languages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public MimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    public HttpCacheToolkit getHttpCacheToolkit() {
        return this.httpCacheToolkit;
    }

    public void registerTemplateEngine(Class<? extends TemplateEngine> engineClass) {
        if (this.templateEngine != null) {
            log.debug("Template engine already registered, ignoring '{}'", (Object)engineClass.getName());
            return;
        }
        try {
            TemplateEngine engine = engineClass.newInstance();
            this.setTemplateEngine(engine);
        }
        catch (Exception e) {
            throw new PippoRuntimeException(e, "Failed to instantiate '{}'", engineClass.getName());
        }
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        templateEngine.init(this);
        this.templateEngine = templateEngine;
        log.debug("Template engine is '{}'", (Object)templateEngine.getClass().getName());
    }

    public ContentTypeEngines getContentTypeEngines() {
        return this.engines;
    }

    public boolean hasContentTypeEngine(String contentType) {
        return this.engines.hasContentTypeEngine(contentType);
    }

    public void registerContentTypeEngine(Class<? extends ContentTypeEngine> engineClass) {
        ContentTypeEngine engine = this.engines.registerContentTypeEngine(engineClass);
        if (engine != null) {
            engine.init(this);
        }
    }

    public ContentTypeEngine getContentTypeEngine(String contentType) {
        return this.engines.getContentTypeEngine(contentType);
    }

    public Router getRouter() {
        if (this.router == null) {
            this.router = new DefaultRouter();
        }
        return this.router;
    }

    public void setRouter(Router router) {
        this.setRouter(router, true);
    }

    public void setRouter(Router router, boolean preserveOldTransformers) {
        if (preserveOldTransformers && router != null) {
            List<RouteTransformer> transformers = this.router.getRouteTransformers();
            transformers.forEach(router::addRouteTransformer);
        }
        this.router = router;
    }

    @Override
    public void addRoute(Route route) {
        this.getRouter().addRoute(route);
    }

    @Override
    public void addRouteGroup(RouteGroup routeGroup) {
        this.getRouter().addRouteGroup(routeGroup);
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this);
        }
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final RequestResponseFactory getRequestResponseFactory() {
        if (this.requestResponseFactory == null) {
            this.requestResponseFactory = this.createRequestResponseFactory();
        }
        return this.requestResponseFactory;
    }

    protected RequestResponseFactory createRequestResponseFactory() {
        return new GZipRequestResponseFactory(this);
    }

    public String getUploadLocation() {
        return this.uploadLocation;
    }

    public void setUploadLocation(String uploadLocation) {
        this.uploadLocation = uploadLocation;
    }

    public long getMaximumUploadSize() {
        return this.maximumUploadSize;
    }

    public void setMaximumUploadSize(long maximumUploadSize) {
        this.maximumUploadSize = maximumUploadSize;
    }

    public RoutePreDispatchListenerList getRoutePreDispatchListeners() {
        if (this.routePreDispatchListeners == null) {
            this.routePreDispatchListeners = new RoutePreDispatchListenerList();
        }
        return this.routePreDispatchListeners;
    }

    public RoutePostDispatchListenerList getRoutePostDispatchListeners() {
        if (this.routePostDispatchListeners == null) {
            this.routePostDispatchListeners = new RoutePostDispatchListenerList();
        }
        return this.routePostDispatchListeners;
    }

    public Map<String, Object> getLocals() {
        if (this.locals == null) {
            this.locals = new HashMap<String, Object>();
        }
        return this.locals;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void addRouteTransformer(RouteTransformer transformer) {
        this.getRouter().addRouteTransformer(transformer);
    }

    public void setNotFoundRouteHandler(RouteHandler routeHandler) {
        this.notFoundRouteHandler = routeHandler;
    }

    public RouteHandler getNotFoundRouteHandler() {
        return this.notFoundRouteHandler;
    }

    public void addWebSocket(String uriPattern, WebSocketHandler webSocketHandler) {
        this.webSocketRouter.addRoute(uriPattern, webSocketHandler);
    }

    public WebSocketRouter getWebSocketRouter() {
        return this.webSocketRouter;
    }

    public static Application get() {
        Object routeContext = RouteDispatcher.getRouteContext();
        return routeContext != null ? (Application)routeContext.getApplication() : null;
    }

    public String toString() {
        String toString = (this.getApplicationName() + " " + this.getApplicationVersion()).trim();
        return toString.isEmpty() ? super.toString() : toString;
    }
}

