/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.util.LangUtils;

public class MethodParameter {
    private final Method method;
    private final int parameterIndex;
    private volatile Parameter parameter;
    private volatile String parameterName;
    private volatile Class<?> parameterType;
    private volatile Class<?> parameterGenericType;

    public MethodParameter(Method method, int parameterIndex) {
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public String getParameterName() {
        Parameter parameter;
        if (this.parameterName == null && (parameter = this.getParameter()).isNamePresent()) {
            this.parameterName = parameter.getName();
        }
        return this.parameterName;
    }

    public Class<?> getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = this.getParameter().getType();
        }
        return this.parameterType;
    }

    public Class<?> getParameterGenericType() {
        if (this.parameterGenericType == null) {
            Parameter parameter = this.getParameter();
            Type parameterType = parameter.getParameterizedType();
            if (!ParameterizedType.class.isAssignableFrom(parameterType.getClass())) {
                throw new PippoRuntimeException("Please specify a generic parameter type for '{}' of '{}'", new Object[]{this.getParameterName(), LangUtils.toString((Method)this.method)});
            }
            ParameterizedType parameterizedType = (ParameterizedType)parameterType;
            try {
                this.parameterGenericType = (Class)parameterizedType.getActualTypeArguments()[0];
            }
            catch (ClassCastException e) {
                throw new PippoRuntimeException("Please specify a generic parameter type for '{}' of '{}'", new Object[]{this.getParameterName(), LangUtils.toString((Method)this.method)});
            }
        }
        return this.parameterGenericType;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getParameter().isAnnotationPresent(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getParameter().getAnnotation(annotationClass);
    }

    private Parameter getParameter() {
        if (this.parameter == null) {
            this.parameter = this.method.getParameters()[this.parameterIndex];
        }
        return this.parameter;
    }
}

