/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import ro.pippo.controller.Consumes;
import ro.pippo.controller.Interceptor;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.Param;
import ro.pippo.controller.util.ClassUtils;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.util.StringUtils;

public class ControllerUtils {
    public static List<Class<? extends RouteHandler>> collectRouteInterceptors(Method method) {
        return ClassUtils.collectNestedAnnotation(method, Interceptor.class).stream().map(Interceptor::value).collect(Collectors.toList());
    }

    public static List<String> getConsumes(Method method) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        Consumes consumes = ClassUtils.getAnnotation(method, Consumes.class);
        if (consumes != null) {
            for (String value : consumes.value()) {
                types.add(value.trim());
            }
        }
        return new ArrayList<String>(types);
    }

    public static List<String> getProduces(Method method) {
        LinkedHashSet<String> contentTypes = new LinkedHashSet<String>();
        Produces produces = ClassUtils.getAnnotation(method, Produces.class);
        if (produces != null) {
            for (String value : produces.value()) {
                contentTypes.add(value.trim());
            }
        }
        return new ArrayList<String>(contentTypes);
    }

    public static Collection<String> getSuffixes(Method method) {
        LinkedHashSet<String> suffixes = new LinkedHashSet<String>();
        for (String produces : ControllerUtils.getProduces(method)) {
            int i = produces.lastIndexOf(47) + 1;
            String type = StringUtils.removeStart((String)produces.substring(i).toLowerCase(), (String)"x-");
            suffixes.add(type);
        }
        return suffixes;
    }

    public static String getParameterName(Parameter parameter) {
        Param param;
        String methodParameterName = parameter.getName();
        if (parameter.isAnnotationPresent(Param.class) && !StringUtils.isNullOrEmpty((String)(param = parameter.getAnnotation(Param.class)).value())) {
            methodParameterName = param.value();
        }
        return methodParameterName;
    }

    public static List<String> cleanupFuzzyContentTypes(List<String> contentTypes) {
        if (contentTypes == null || contentTypes.isEmpty()) {
            return contentTypes;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (String contentType : contentTypes) {
            if (contentType.equals("*") || contentType.equals("*/*")) {
                types.add(contentType);
                continue;
            }
            int i = contentType.indexOf(42);
            if (i > -1) {
                types.add(contentType.substring(0, i));
                continue;
            }
            types.add(contentType);
        }
        return types;
    }
}

