/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerFactory;
import ro.pippo.controller.ControllerInitializationListenerList;
import ro.pippo.controller.ControllerInstantiationListenerList;
import ro.pippo.controller.ControllerInvokeListenerList;
import ro.pippo.controller.ControllerRegistry;
import ro.pippo.controller.DefaultControllerFactory;
import ro.pippo.controller.extractor.MethodParameterExtractor;
import ro.pippo.core.Application;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.util.ServiceLocator;

public class ControllerApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(ControllerApplication.class);
    private ControllerInstantiationListenerList controllerInstantiationListeners;
    private ControllerInitializationListenerList controllerInitializationListeners;
    private ControllerInvokeListenerList controllerInvokeListeners;
    private ControllerFactory controllerFactory;
    private List<MethodParameterExtractor> extractors;

    public ControllerApplication() {
    }

    public ControllerApplication(PippoSettings settings) {
        super(settings);
    }

    public ControllerInstantiationListenerList getControllerInstantiationListeners() {
        if (this.controllerInstantiationListeners == null) {
            this.controllerInstantiationListeners = new ControllerInstantiationListenerList();
        }
        return this.controllerInstantiationListeners;
    }

    public ControllerInitializationListenerList getControllerInitializationListeners() {
        if (this.controllerInitializationListeners == null) {
            this.controllerInitializationListeners = new ControllerInitializationListenerList();
        }
        return this.controllerInitializationListeners;
    }

    public ControllerInvokeListenerList getControllerInvokeListeners() {
        if (this.controllerInvokeListeners == null) {
            this.controllerInvokeListeners = new ControllerInvokeListenerList();
        }
        return this.controllerInvokeListeners;
    }

    public ControllerFactory getControllerFactory() {
        if (this.controllerFactory == null) {
            this.controllerFactory = new DefaultControllerFactory();
        }
        return this.controllerFactory;
    }

    public ControllerApplication setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
        log.debug("Controller factory is '{}'", (Object)controllerFactory.getClass().getName());
        return this;
    }

    public ControllerApplication addExtractors(MethodParameterExtractor ... extractors) {
        this.getExtractors().addAll(Arrays.asList(extractors));
        return this;
    }

    public List<MethodParameterExtractor> getExtractors() {
        if (this.extractors == null) {
            this.extractors = ServiceLocator.locateAll(MethodParameterExtractor.class);
        }
        return this.extractors;
    }

    public ControllerApplication addControllers(String ... packageNames) {
        ControllerRegistry controllerRegistry = new ControllerRegistry(this);
        controllerRegistry.register(packageNames);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Package ... packages) {
        ControllerRegistry controllerRegistry = new ControllerRegistry(this);
        controllerRegistry.register(packages);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Class<? extends Controller> ... controllerClasses) {
        ControllerRegistry controllerRegistry = new ControllerRegistry(this);
        controllerRegistry.register(controllerClasses);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Controller ... controllers) {
        ControllerRegistry controllerRegistry = new ControllerRegistry(this);
        controllerRegistry.register(controllers);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }
}

