/*
 * Decompiled with CFR 0.152.
 */
package rikka.shizuku;

import android.annotation.SuppressLint;
import android.os.IBinder;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SuppressLint(value={"PrivateApi"})
public class SystemServiceHelper {
    private static final Map<String, IBinder> SYSTEM_SERVICE_CACHE = new HashMap<String, IBinder>();
    private static final Map<String, Integer> TRANSACT_CODE_CACHE = new HashMap<String, Integer>();
    private static Method getService;

    public static IBinder getSystemService(@NonNull String name) {
        IBinder binder = SYSTEM_SERVICE_CACHE.get(name);
        if (binder == null) {
            try {
                binder = (IBinder)getService.invoke(null, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Log.w((String)"SystemServiceHelper", (String)Log.getStackTraceString((Throwable)e));
            }
            SYSTEM_SERVICE_CACHE.put(name, binder);
        }
        return binder;
    }

    public static Integer getTransactionCode(@NonNull String className, @NonNull String methodName) {
        String fieldName = "TRANSACTION_" + methodName;
        String key = className + "." + fieldName;
        Integer value = TRANSACT_CODE_CACHE.get(key);
        if (value != null) {
            return value;
        }
        try {
            Class<?> cls = Class.forName(className);
            Field declaredField = null;
            try {
                declaredField = cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                for (Field f : cls.getDeclaredFields()) {
                    String name;
                    if (f.getType() != Integer.TYPE || !(name = f.getName()).startsWith(fieldName + "_") || !TextUtils.isDigitsOnly((CharSequence)name.substring(fieldName.length() + 1))) continue;
                    declaredField = f;
                    break;
                }
            }
            if (declaredField == null) {
                return null;
            }
            declaredField.setAccessible(true);
            value = declaredField.getInt(cls);
            TRANSACT_CODE_CACHE.put(key, value);
            return value;
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Parcel obtainParcel(@NonNull String serviceName, @NonNull String interfaceName, @NonNull String methodName) {
        return SystemServiceHelper.obtainParcel(serviceName, interfaceName, interfaceName + "$Stub", methodName);
    }

    public static Parcel obtainParcel(@NonNull String serviceName, @NonNull String interfaceName, @NonNull String className, @NonNull String methodName) {
        IBinder binder = SystemServiceHelper.getSystemService(serviceName);
        Integer code = SystemServiceHelper.getTransactionCode(className, methodName);
        Objects.requireNonNull(binder, "can't find system service " + serviceName);
        Objects.requireNonNull(code, "can't find transaction code of " + methodName + " in " + className);
        Parcel data = Parcel.obtain();
        data.writeInterfaceToken("moe.shizuku.server.IShizukuService");
        data.writeStrongBinder(binder);
        data.writeInt(code.intValue());
        data.writeInterfaceToken(interfaceName);
        return data;
    }

    static {
        try {
            Class<?> sm = Class.forName("android.os.ServiceManager");
            getService = sm.getMethod("getService", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Log.w((String)"SystemServiceHelper", (String)Log.getStackTraceString((Throwable)e));
        }
    }
}

