/*
 * Decompiled with CFR 0.152.
 */
package rikka.shizuku;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.shizuku.server.IShizukuServiceConnection;
import rikka.shizuku.Shizuku;

class ShizukuServiceConnection
extends IShizukuServiceConnection.Stub {
    private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());
    private static final Map<String, ShizukuServiceConnection> CACHE = Collections.synchronizedMap(new HashMap());
    private final Set<ServiceConnection> connections = new HashSet<ServiceConnection>();
    private final ComponentName componentName;
    private boolean dead = false;

    @Nullable
    static ShizukuServiceConnection get(Shizuku.UserServiceArgs args) {
        String key = args.tag != null ? args.tag : args.componentName.getClassName();
        return CACHE.get(key);
    }

    @NonNull
    static ShizukuServiceConnection getOrCreate(Shizuku.UserServiceArgs args) {
        String key = args.tag != null ? args.tag : args.componentName.getClassName();
        ShizukuServiceConnection connection = CACHE.get(key);
        if (connection == null) {
            connection = new ShizukuServiceConnection(args);
            CACHE.put(key, connection);
        }
        return connection;
    }

    public ShizukuServiceConnection(Shizuku.UserServiceArgs args) {
        this.componentName = args.componentName;
    }

    public void addConnection(@Nullable ServiceConnection conn) {
        if (conn != null) {
            this.connections.add(conn);
        }
    }

    public void removeConnection(@Nullable ServiceConnection conn) {
        if (conn != null) {
            this.connections.remove(conn);
        }
    }

    public void connected(IBinder binder) {
        MAIN_HANDLER.post(() -> {
            for (ServiceConnection conn : this.connections) {
                conn.onServiceConnected(this.componentName, binder);
            }
        });
        try {
            binder.linkToDeath(this::dead, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void dead() {
        if (this.dead) {
            return;
        }
        this.dead = true;
        MAIN_HANDLER.post(() -> {
            for (ServiceConnection conn : this.connections) {
                conn.onServiceDisconnected(this.componentName);
            }
        });
    }
}

