/*
 * Decompiled with CFR 0.152.
 */
package rikka.shizuku;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import moe.shizuku.server.IShizukuApplication;
import moe.shizuku.server.IShizukuService;
import moe.shizuku.server.IShizukuServiceConnection;
import rikka.shizuku.ShizukuRemoteProcess;
import rikka.shizuku.ShizukuServiceConnection;

public class Shizuku {
    private static IBinder binder;
    private static IShizukuService service;
    private static int serverUid;
    private static int serverVersion;
    private static String serverContext;
    private static boolean permissionGranted;
    private static boolean shouldShowRequestPermissionRationale;
    private static boolean preV11;
    private static final IShizukuApplication SHIZUKU_APPLICATION;
    private static final IBinder.DeathRecipient DEATH_RECIPIENT;
    private static final List<OnBinderReceivedListener> RECEIVED_LISTENERS;
    private static final List<OnBinderDeadListener> DEAD_LISTENERS;
    private static final List<OnRequestPermissionResultListener> PERMISSION_LISTENERS;
    private static final Handler MAIN_HANDLER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void onBinderReceived(@Nullable IBinder newBinder, String packageName) {
        if (binder == newBinder) {
            return;
        }
        if (newBinder == null) {
            binder = null;
            service = null;
            serverUid = -1;
            serverVersion = -1;
            serverContext = null;
            Shizuku.scheduleBinderDeadListeners();
        } else {
            if (binder != null) {
                binder.unlinkToDeath(DEATH_RECIPIENT, 0);
            }
            binder = newBinder;
            service = IShizukuService.Stub.asInterface((IBinder)newBinder);
            try {
                binder.linkToDeath(DEATH_RECIPIENT, 0);
            }
            catch (Throwable e) {
                Log.i((String)"ShizukuApplication", (String)"attachApplication");
            }
            try {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken("moe.shizuku.server.IShizukuService");
                    data.writeStrongBinder(SHIZUKU_APPLICATION.asBinder());
                    data.writeString(packageName);
                    preV11 = !binder.transact(14, data, reply, 0);
                    reply.readException();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                Log.i((String)"ShizukuApplication", (String)"attachApplication");
            }
            catch (Throwable e) {
                Log.w((String)"ShizukuApplication", (String)Log.getStackTraceString((Throwable)e));
            }
            Shizuku.scheduleBinderReceivedListeners();
        }
    }

    public static void addBinderReceivedListener(@NonNull OnBinderReceivedListener listener) {
        Shizuku.addBinderReceivedListener(Objects.requireNonNull(listener), false);
    }

    public static void addBinderReceivedListenerSticky(@NonNull OnBinderReceivedListener listener) {
        Shizuku.addBinderReceivedListener(Objects.requireNonNull(listener), true);
    }

    private static void addBinderReceivedListener(@NonNull OnBinderReceivedListener listener, boolean sticky) {
        if (sticky && Shizuku.pingBinder()) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                listener.onBinderReceived();
            } else {
                MAIN_HANDLER.post(listener::onBinderReceived);
            }
        }
        RECEIVED_LISTENERS.add(listener);
    }

    public static boolean removeBinderReceivedListener(@NonNull OnBinderReceivedListener listener) {
        return RECEIVED_LISTENERS.remove(listener);
    }

    private static void scheduleBinderReceivedListeners() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Shizuku.dispatchBinderReceivedListeners();
        } else {
            MAIN_HANDLER.post(Shizuku::dispatchBinderReceivedListeners);
        }
    }

    private static void dispatchBinderReceivedListeners() {
        for (OnBinderReceivedListener listener : RECEIVED_LISTENERS) {
            listener.onBinderReceived();
        }
    }

    public static void addBinderDeadListener(@NonNull OnBinderDeadListener listener) {
        DEAD_LISTENERS.add(listener);
    }

    public static boolean removeBinderDeadListener(@NonNull OnBinderDeadListener listener) {
        return DEAD_LISTENERS.remove(listener);
    }

    private static void scheduleBinderDeadListeners() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Shizuku.dispatchBinderDeadListeners();
        } else {
            MAIN_HANDLER.post(Shizuku::dispatchBinderDeadListeners);
        }
    }

    private static void dispatchBinderDeadListeners() {
        for (OnBinderDeadListener listener : DEAD_LISTENERS) {
            listener.onBinderDead();
        }
    }

    public static void addRequestPermissionResultListener(@NonNull OnRequestPermissionResultListener listener) {
        PERMISSION_LISTENERS.add(listener);
    }

    public static boolean removeRequestPermissionResultListener(@NonNull OnRequestPermissionResultListener listener) {
        return PERMISSION_LISTENERS.remove(listener);
    }

    static void scheduleRequestPermissionResultListener(int requestCode, int result) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Shizuku.dispatchRequestPermissionResultListener(requestCode, result);
        } else {
            MAIN_HANDLER.post(() -> Shizuku.dispatchRequestPermissionResultListener(requestCode, result));
        }
    }

    static void dispatchRequestPermissionResultListener(int requestCode, int result) {
        for (OnRequestPermissionResultListener listener : PERMISSION_LISTENERS) {
            listener.onRequestPermissionResult(requestCode, result);
        }
    }

    @NonNull
    protected static IShizukuService requireService() {
        if (service == null) {
            throw new IllegalStateException("binder haven't been received");
        }
        return service;
    }

    @Nullable
    public static IBinder getBinder() {
        return binder;
    }

    public static boolean pingBinder() {
        return binder != null && binder.pingBinder();
    }

    private static RuntimeException rethrowAsRuntimeException(RemoteException e) {
        return new RuntimeException(e);
    }

    public static void transactRemote(@NonNull Parcel data, @Nullable Parcel reply, int flags) {
        try {
            Shizuku.requireService().asBinder().transact(1, data, reply, flags);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    @Deprecated
    public static ShizukuRemoteProcess newProcess(@NonNull String[] cmd, @Nullable String[] env, @Nullable String dir) {
        try {
            return new ShizukuRemoteProcess(Shizuku.requireService().newProcess(cmd, env, dir));
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    public static int getUid() {
        if (serverUid != -1) {
            return serverUid;
        }
        try {
            serverUid = Shizuku.requireService().getUid();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
        return serverUid;
    }

    public static int getVersion() {
        if (serverVersion != -1) {
            return serverVersion;
        }
        try {
            serverVersion = Shizuku.requireService().getVersion();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
        return serverVersion;
    }

    public static boolean isPreV11() {
        return preV11;
    }

    public static int getLatestServiceVersion() {
        return 11;
    }

    public static int checkRemotePermission(String permission) {
        if (serverUid == 0) {
            return 0;
        }
        try {
            return Shizuku.requireService().checkPermission(permission);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    public static String getSELinuxContext() {
        if (serverContext != null) {
            return serverContext;
        }
        try {
            serverContext = Shizuku.requireService().getSELinuxContext();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
        return serverContext;
    }

    public static void bindUserService(@NonNull UserServiceArgs args, @NonNull ServiceConnection conn) {
        ShizukuServiceConnection connection = ShizukuServiceConnection.getOrCreate(args);
        connection.addConnection(conn);
        try {
            Shizuku.requireService().addUserService((IShizukuServiceConnection)connection, args.forAdd());
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    public static void unbindUserService(@NonNull UserServiceArgs args, @NonNull ServiceConnection conn, boolean remove) {
        ShizukuServiceConnection connection = ShizukuServiceConnection.get(args);
        if (connection != null) {
            connection.removeConnection(conn);
        }
        if (remove) {
            try {
                Shizuku.requireService().removeUserService(null, args.forRemove());
            }
            catch (RemoteException e) {
                throw Shizuku.rethrowAsRuntimeException(e);
            }
        }
    }

    public static void requestPermission(int requestCode) {
        try {
            Shizuku.requireService().requestPermission(requestCode);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    public static int checkSelfPermission() {
        if (permissionGranted) {
            return 0;
        }
        try {
            permissionGranted = Shizuku.requireService().checkSelfPermission();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
        return permissionGranted ? 0 : -1;
    }

    public static boolean shouldShowRequestPermissionRationale() {
        if (permissionGranted) {
            return false;
        }
        if (shouldShowRequestPermissionRationale) {
            return true;
        }
        try {
            shouldShowRequestPermissionRationale = Shizuku.requireService().shouldShowRequestPermissionRationale();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
        return shouldShowRequestPermissionRationale;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void exit() {
        try {
            Shizuku.requireService().exit();
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void attachUserService(@NonNull IBinder binder, @NonNull Bundle options) {
        try {
            Shizuku.requireService().attachUserService(binder, options);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void dispatchPermissionConfirmationResult(int requestUid, int requestPid, int requestCode, @NonNull Bundle data) {
        try {
            Shizuku.requireService().dispatchPermissionConfirmationResult(requestUid, requestPid, requestCode, data);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static int getFlagsForUid(int uid, int mask) {
        try {
            return Shizuku.requireService().getFlagsForUid(uid, mask);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void updateFlagsForUid(int uid, int mask, int value) {
        try {
            Shizuku.requireService().updateFlagsForUid(uid, mask, value);
        }
        catch (RemoteException e) {
            throw Shizuku.rethrowAsRuntimeException(e);
        }
    }

    static {
        serverUid = -1;
        serverVersion = -1;
        serverContext = null;
        permissionGranted = false;
        shouldShowRequestPermissionRationale = false;
        preV11 = false;
        SHIZUKU_APPLICATION = new IShizukuApplication.Stub(){

            public void bindApplication(Bundle data) {
                serverUid = data.getInt("shizuku:attach-reply-uid", -1);
                serverVersion = data.getInt("shizuku:attach-reply-version", -1);
                serverContext = data.getString("shizuku:attach-reply-secontext");
                permissionGranted = data.getBoolean("shizuku:attach-reply-permission-granted", false);
                shouldShowRequestPermissionRationale = data.getBoolean("shizuku:attach-reply-should-show-request-permission-rationale", false);
            }

            public void dispatchRequestPermissionResult(int requestCode, Bundle data) {
                boolean allowed = data.getBoolean("shizuku:request-permission-reply-allowed", false);
                Shizuku.scheduleRequestPermissionResultListener(requestCode, allowed ? 0 : -1);
            }

            public void showPermissionConfirmation(int requestUid, int requestPid, String requestPackageName, int requestCode) {
            }
        };
        DEATH_RECIPIENT = () -> Shizuku.onBinderReceived(null, null);
        RECEIVED_LISTENERS = new CopyOnWriteArrayList<OnBinderReceivedListener>();
        DEAD_LISTENERS = new CopyOnWriteArrayList<OnBinderDeadListener>();
        PERMISSION_LISTENERS = new CopyOnWriteArrayList<OnRequestPermissionResultListener>();
        MAIN_HANDLER = new Handler(Looper.getMainLooper());
    }

    public static class UserServiceArgs {
        final ComponentName componentName;
        int versionCode = 1;
        String processName;
        String tag;
        boolean debuggable = false;

        public UserServiceArgs(@NonNull ComponentName componentName) {
            this.componentName = componentName;
        }

        public UserServiceArgs tag(@NonNull String tag) {
            this.tag = tag;
            return this;
        }

        public UserServiceArgs version(int versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public UserServiceArgs debuggable(boolean debuggable) {
            this.debuggable = debuggable;
            return this;
        }

        public UserServiceArgs processNameSuffix(String processNameSuffix) {
            this.processName = processNameSuffix;
            return this;
        }

        private Bundle forAdd() {
            Bundle options = new Bundle();
            options.putParcelable("shizuku:user-service-arg-component", (Parcelable)this.componentName);
            options.putBoolean("shizuku:user-service-arg-debuggable", this.debuggable);
            options.putInt("shizuku:user-service-arg-version-code", this.versionCode);
            options.putString("shizuku:user-service-arg-process-name", Objects.requireNonNull(this.processName, "process name suffix must not be null when using standalone process mode"));
            if (this.tag != null) {
                options.putString("shizuku:user-service-arg-tag", this.tag);
            }
            return options;
        }

        private Bundle forRemove() {
            Bundle options = new Bundle();
            options.putParcelable("shizuku:user-service-arg-component", (Parcelable)this.componentName);
            if (this.tag != null) {
                options.putString("shizuku:user-service-arg-tag", this.tag);
            }
            return options;
        }
    }

    public static interface OnRequestPermissionResultListener {
        public void onRequestPermissionResult(int var1, int var2);
    }

    public static interface OnBinderDeadListener {
        public void onBinderDead();
    }

    public static interface OnBinderReceivedListener {
        public void onBinderReceived();
    }
}

