/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Delay {
    protected Delay() {
    }

    public abstract Duration delay(long var1);

    public static Delay constant(Duration delay) {
        return new ConstantDelay(delay);
    }

    public static Delay exponentialWithJitter(Duration lower, Duration upper, Duration base) {
        return new EqualJitterDelay(lower, upper, base);
    }

    static class EqualJitterDelay
    extends Delay {
        private final long lowerMillis;
        private final long upperMillis;
        private final long baseMillis;

        EqualJitterDelay(Duration lower, Duration upper, Duration base) {
            this.lowerMillis = lower.toMillis();
            this.upperMillis = upper.toMillis();
            this.baseMillis = base.toMillis();
        }

        @Override
        public Duration delay(long attempt) {
            long exponential = this.baseMillis * (1L << (int)Math.min(attempt, 62L));
            long temp = Math.min(this.upperMillis, exponential);
            long half = temp / 2L;
            long jitter = ThreadLocalRandom.current().nextLong(half + 1L);
            long delayMillis = half + jitter;
            delayMillis = Math.max(this.lowerMillis, delayMillis);
            return Duration.ofMillis(delayMillis);
        }
    }

    static class ConstantDelay
    extends Delay {
        private final Duration delay;

        ConstantDelay(Duration delay) {
            this.delay = delay;
        }

        @Override
        public Duration delay(long attempt) {
            return this.delay;
        }
    }
}

