/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.hybrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.util.KeyValue;

@Experimental
public class HybridResult {
    private static final String KEY_FIELD = "__key";
    private static final String SCORE_FIELD = "__score";
    private final long totalResults;
    private final double executionTime;
    private final List<Document> documents;
    private final List<String> warnings;
    public static final Builder<HybridResult> HYBRID_RESULT_BUILDER = new Builder<HybridResult>(){
        private static final String TOTAL_RESULTS_STR = "total_results";
        private static final String EXECUTION_TIME_STR = "execution_time";
        private static final String RESULTS_STR = "results";
        private static final String WARNINGS_STR = "warnings";

        @Override
        public HybridResult build(Object data) {
            List list = (List)data;
            if (!list.isEmpty() && list.get(0) instanceof KeyValue) {
                return this.buildResp3(list);
            }
            return this.buildResp2(list);
        }

        private HybridResult buildResp3(List<KeyValue> list) {
            long totalResults = -1L;
            double executionTime = 0.0;
            ArrayList<Document> documents = null;
            List<String> warnings = null;
            block12: for (KeyValue kv : list) {
                String key = BuilderFactory.STRING.build(kv.getKey());
                Object rawVal = kv.getValue();
                switch (key) {
                    case "total_results": {
                        totalResults = BuilderFactory.LONG.build(rawVal);
                        break;
                    }
                    case "execution_time": {
                        executionTime = BuilderFactory.DOUBLE.build(rawVal);
                        break;
                    }
                    case "results": {
                        documents = new ArrayList<Document>();
                        List resultsList = (List)rawVal;
                        for (Object resultObj : resultsList) {
                            Map<String, Object> resultMap = BuilderFactory.ENCODED_OBJECT_MAP.build(resultObj);
                            documents.add(HybridResult.mapToDocument(resultMap));
                        }
                        continue block12;
                    }
                    case "warnings": {
                        warnings = BuilderFactory.STRING_LIST.build(rawVal);
                    }
                }
            }
            return new HybridResult(totalResults, executionTime, documents, warnings);
        }

        private HybridResult buildResp2(List list) {
            long totalResults = -1L;
            double executionTime = 0.0;
            ArrayList<Document> documents = null;
            List<String> warnings = null;
            int i = 0;
            while (i + 1 < list.size()) {
                String key = BuilderFactory.STRING.build(list.get(i));
                Object rawVal = list.get(i + 1);
                switch (key) {
                    case "total_results": {
                        totalResults = BuilderFactory.LONG.build(rawVal);
                        break;
                    }
                    case "execution_time": {
                        executionTime = BuilderFactory.DOUBLE.build(rawVal);
                        break;
                    }
                    case "results": {
                        documents = new ArrayList<Document>();
                        List resultsList = (List)rawVal;
                        for (Object resultObj : resultsList) {
                            Map<String, Object> resultMap = BuilderFactory.ENCODED_OBJECT_MAP.build(resultObj);
                            documents.add(HybridResult.mapToDocument(resultMap));
                        }
                        break;
                    }
                    case "warnings": {
                        warnings = BuilderFactory.STRING_LIST.build(rawVal);
                    }
                }
                i += 2;
            }
            return new HybridResult(totalResults, executionTime, documents, warnings);
        }
    };

    private HybridResult(long totalResults, double executionTime, List<Document> documents, List<String> warnings) {
        this.totalResults = totalResults;
        this.executionTime = executionTime;
        this.documents = documents != null ? documents : Collections.emptyList();
        this.warnings = warnings != null ? warnings : Collections.emptyList();
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public double getExecutionTime() {
        return this.executionTime;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{Total results:" + this.totalResults + ", Execution time:" + this.executionTime + ", Documents:" + this.documents + (this.warnings != null ? ", Warnings:" + this.warnings : "") + "}";
    }

    private static Document mapToDocument(Map<String, Object> map) {
        String id = null;
        Double score = null;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (KEY_FIELD.equals(key)) {
                id = value != null ? value.toString() : null;
                continue;
            }
            if (SCORE_FIELD.equals(key)) {
                score = value != null ? Double.valueOf(Double.parseDouble(value.toString())) : null;
                continue;
            }
            fields.put(key, value);
        }
        return new Document(id, fields, score != null ? score : 1.0);
    }
}

