/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.search.Scorer;

@Experimental
public class Scorers {
    private static final Scorer TFIDF = Scorers.scorer("TFIDF");
    private static final Scorer TFIDF_DOCNORM = Scorers.scorer("TFIDF.DOCNORM");
    private static final Scorer BM25STD = Scorers.scorer("BM25STD");
    private static final Scorer BM25STD_NORM = Scorers.scorer("BM25STD.NORM");
    private static final Scorer DISMAX = Scorers.scorer("DISMAX");
    private static final Scorer DOCSCORE = Scorers.scorer("DOCSCORE");
    private static final Scorer HAMMING = Scorers.scorer("HAMMING");

    private Scorers() {
    }

    private static Scorer scorer(String name) {
        return new Scorer(name){};
    }

    public static Scorer tfidf() {
        return TFIDF;
    }

    public static Scorer tfidfDocnorm() {
        return TFIDF_DOCNORM;
    }

    public static Scorer bm25std() {
        return BM25STD;
    }

    public static Scorer bm25stdNorm() {
        return BM25STD_NORM;
    }

    public static Scorer dismax() {
        return DISMAX;
    }

    public static Scorer docscore() {
        return DOCSCORE;
    }

    public static Scorer hamming() {
        return HAMMING;
    }
}

