/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;

public class XCfgSetParams
implements IParams {
    private Integer idmpDuration;
    private Integer idmpMaxsize;

    public static XCfgSetParams xCfgSetParams() {
        return new XCfgSetParams();
    }

    public XCfgSetParams idmpDuration(int duration) {
        if (duration < 1 || duration > 86400) {
            throw new IllegalArgumentException("IDMP-DURATION must be between 1 and 86400 seconds");
        }
        this.idmpDuration = duration;
        return this;
    }

    public XCfgSetParams idmpMaxsize(int maxsize) {
        if (maxsize < 1 || maxsize > 10000) {
            throw new IllegalArgumentException("IDMP-MAXSIZE must be between 1 and 10000");
        }
        this.idmpMaxsize = maxsize;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.idmpDuration != null) {
            args.add("IDMP-DURATION").add(this.idmpDuration);
        }
        if (this.idmpMaxsize != null) {
            args.add("IDMP-MAXSIZE").add(this.idmpMaxsize);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XCfgSetParams that = (XCfgSetParams)o;
        return Objects.equals(this.idmpDuration, that.idmpDuration) && Objects.equals(this.idmpMaxsize, that.idmpMaxsize);
    }

    public int hashCode() {
        return Objects.hash(this.idmpDuration, this.idmpMaxsize);
    }
}

