/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import redis.clients.jedis.MultiDbConfig;

class CircuitBreakerThresholdsAdapter {
    private static final float FAILURE_RATE_THRESHOLD_MAX = 100.0f;
    private float failureRateThreshold = 100.0f;
    private int minimumNumberOfCalls = Integer.MAX_VALUE;
    private int slidingWindowSize;

    int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    CircuitBreakerConfig.SlidingWindowType getSlidingWindowType() {
        return CircuitBreakerConfig.SlidingWindowType.TIME_BASED;
    }

    int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    CircuitBreakerThresholdsAdapter(MultiDbConfig multiDbConfig) {
        this.slidingWindowSize = multiDbConfig.getFailureDetector().getSlidingWindowSize();
    }
}

