/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.builders.StandaloneClientBuilder;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.providers.PooledConnectionProvider;
import redis.clients.jedis.util.Pool;

public class RedisClient
extends UnifiedJedis {
    private RedisClient(CommandExecutor commandExecutor, ConnectionProvider connectionProvider, CommandObjects commandObjects, RedisProtocol redisProtocol, Cache cache) {
        super(commandExecutor, connectionProvider, commandObjects, redisProtocol, cache);
    }

    public static RedisClient create() {
        return (RedisClient)RedisClient.builder().build();
    }

    public static RedisClient create(String url) {
        return (RedisClient)RedisClient.builder().fromURI(url).build();
    }

    public static RedisClient create(String host, int port) {
        return (RedisClient)RedisClient.builder().hostAndPort(host, port).build();
    }

    public static RedisClient create(HostAndPort hostAndPort) {
        return (RedisClient)RedisClient.builder().hostAndPort(hostAndPort).build();
    }

    public static RedisClient create(String host, int port, String user, String password) {
        return (RedisClient)((StandaloneClientBuilder)RedisClient.builder().hostAndPort(host, port).clientConfig(DefaultJedisClientConfig.builder().user(user).password(password).build())).build();
    }

    public static RedisClient create(URI uri) {
        return (RedisClient)RedisClient.builder().fromURI(uri).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Pool<Connection> getPool() {
        return ((PooledConnectionProvider)this.provider).getPool();
    }

    @Override
    public Pipeline pipelined() {
        return (Pipeline)super.pipelined();
    }

    public static class Builder
    extends StandaloneClientBuilder<RedisClient> {
        @Override
        protected RedisClient createClient() {
            return new RedisClient(this.commandExecutor, this.connectionProvider, this.commandObjects, this.clientConfig.getRedisProtocol(), this.cache);
        }
    }
}

