/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.DriverInfo;
import redis.clients.jedis.exceptions.JedisValidationException;

public final class ClientSetInfoConfig {
    private final boolean disabled;
    private final DriverInfo driverInfo;
    public static final ClientSetInfoConfig DEFAULT = new ClientSetInfoConfig();
    public static final ClientSetInfoConfig DISABLED = new ClientSetInfoConfig(true);

    public ClientSetInfoConfig() {
        this(false);
    }

    public ClientSetInfoConfig(boolean disabled) {
        this.disabled = disabled;
        this.driverInfo = DriverInfo.builder().build();
    }

    public ClientSetInfoConfig(String libNameSuffix) {
        this.disabled = false;
        this.driverInfo = DriverInfo.builder().addUpstreamDriver(libNameSuffix).build();
    }

    public ClientSetInfoConfig(DriverInfo driverInfo) {
        if (driverInfo == null) {
            throw new JedisValidationException("DriverInfo must not be null");
        }
        this.disabled = false;
        this.driverInfo = driverInfo;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public DriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    public String getUpstreamDrivers() {
        return this.driverInfo.getUpstreamDrivers();
    }

    public static ClientSetInfoConfig withLibNameSuffix(String suffix) {
        return new ClientSetInfoConfig(suffix);
    }
}

