/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.csc.ClientSideCache;
import redis.clients.jedis.csc.ClientSideCacheable;
import redis.clients.jedis.csc.DefaultClientSideCacheable;
import redis.clients.jedis.csc.hash.CommandLongHasher;
import redis.clients.jedis.csc.hash.SimpleCommandHasher;

public class CaffeineClientSideCache
extends ClientSideCache {
    private final Cache<Long, Object> cache;

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache) {
        this(caffeineCache, SimpleCommandHasher.INSTANCE);
    }

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache, CommandLongHasher commandHasher) {
        this(caffeineCache, commandHasher, DefaultClientSideCacheable.INSTANCE);
    }

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache, ClientSideCacheable cacheable) {
        this(caffeineCache, SimpleCommandHasher.INSTANCE, cacheable);
    }

    public CaffeineClientSideCache(Cache<Long, Object> caffeineCache, CommandLongHasher commandHasher, ClientSideCacheable cacheable) {
        super(commandHasher, cacheable);
        this.cache = caffeineCache;
    }

    @Override
    protected final void invalidateAllHashes() {
        this.cache.invalidateAll();
    }

    @Override
    protected void invalidateHashes(Iterable<Long> hashes) {
        this.cache.invalidateAll(hashes);
    }

    @Override
    protected void putValue(long hash, Object value) {
        this.cache.put((Object)hash, value);
    }

    @Override
    protected Object getValue(long hash) {
        return this.cache.getIfPresent((Object)hash);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long maximumSize = 10000L;
        private long expireTime = 100L;
        private final TimeUnit expireTimeUnit = TimeUnit.SECONDS;
        private CommandLongHasher commandHasher = SimpleCommandHasher.INSTANCE;
        private ClientSideCacheable cacheable = DefaultClientSideCacheable.INSTANCE;

        private Builder() {
        }

        public Builder maximumSize(int size) {
            this.maximumSize = size;
            return this;
        }

        public Builder ttl(int seconds) {
            this.expireTime = seconds;
            return this;
        }

        public Builder commandHasher(CommandLongHasher commandHasher) {
            this.commandHasher = commandHasher;
            return this;
        }

        public Builder cacheable(ClientSideCacheable cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public CaffeineClientSideCache build() {
            Caffeine cb = Caffeine.newBuilder();
            cb.maximumSize(this.maximumSize);
            cb.expireAfterWrite(this.expireTime, this.expireTimeUnit);
            return new CaffeineClientSideCache((Cache<Long, Object>)cb.build(), this.commandHasher, this.cacheable);
        }
    }
}

