/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.net.URI;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.csc.CaffeineClientSideCache;
import redis.clients.jedis.csc.ClientSideCache;
import redis.clients.jedis.csc.GuavaClientSideCache;

public final class JedisURIHelper {
    private static final String REDIS = "redis";
    private static final String REDISS = "rediss";
    private static final Integer ZERO_INTEGER = 0;

    private JedisURIHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static HostAndPort getHostAndPort(URI uri) {
        return new HostAndPort(uri.getHost(), uri.getPort());
    }

    public static String getUser(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String user = userInfo.split(":", 2)[0];
            if (user.isEmpty()) {
                user = null;
            }
            return user;
        }
        return null;
    }

    public static String getPassword(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            return userInfo.split(":", 2)[1];
        }
        return null;
    }

    public static int getDBIndex(URI uri) {
        String[] pathSplit = uri.getPath().split("/", 2);
        if (pathSplit.length > 1) {
            String dbIndexStr = pathSplit[1];
            if (dbIndexStr.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(dbIndexStr);
        }
        return 0;
    }

    public static RedisProtocol getRedisProtocol(URI uri) {
        String[] params;
        if (uri.getQuery() == null) {
            return null;
        }
        for (String param : params = uri.getQuery().split("&")) {
            int idx = param.indexOf("=");
            if (idx < 0 || !"protocol".equals(param.substring(0, idx))) continue;
            String ver = param.substring(idx + 1);
            for (RedisProtocol proto : RedisProtocol.values()) {
                if (!proto.version().equals(ver)) continue;
                return proto;
            }
            throw new IllegalArgumentException("Unknown protocol " + ver);
        }
        return null;
    }

    public static ClientSideCache getClientSideCache(URI uri) {
        String[] params;
        if (uri.getQuery() == null) {
            return null;
        }
        boolean guava = false;
        boolean caffeine = false;
        Integer maxSize = null;
        Integer ttl = null;
        block22: for (String param : params = uri.getQuery().split("&")) {
            int idx = param.indexOf("=");
            if (idx < 0) continue;
            String key = param.substring(0, idx);
            String val = param.substring(idx + 1);
            switch (key) {
                case "cache_lib": {
                    switch (val) {
                        case "guava": {
                            guava = true;
                            continue block22;
                        }
                        case "caffeine": {
                            caffeine = true;
                            continue block22;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported library " + val);
                }
                case "cache_max_size": {
                    try {
                        maxSize = Integer.parseInt(val);
                        continue block22;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Value of cache_max_size must be an integer.", nfe);
                    }
                }
                case "cache_ttl": {
                    try {
                        ttl = Integer.parseInt(val);
                        continue block22;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Value of cache_ttl must be an integer denoting seconds.", nfe);
                    }
                }
            }
        }
        if (ZERO_INTEGER.equals(maxSize)) {
            return null;
        }
        if (!(guava || caffeine || maxSize == null && ttl == null)) {
            throw new IllegalArgumentException("The cache library (guava OR caffeine) must be selected.");
        }
        if (ZERO_INTEGER.equals(ttl)) {
            ttl = null;
        }
        if (guava) {
            GuavaClientSideCache.Builder guavaBuilder = GuavaClientSideCache.builder();
            if (maxSize != null) {
                guavaBuilder.maximumSize(maxSize);
            }
            if (ttl != null) {
                guavaBuilder.ttl(ttl);
            }
            return guavaBuilder.build();
        }
        if (caffeine) {
            CaffeineClientSideCache.Builder caffeineBuilder = CaffeineClientSideCache.builder();
            if (maxSize != null) {
                caffeineBuilder.maximumSize(maxSize);
            }
            if (ttl != null) {
                caffeineBuilder.ttl(ttl);
            }
            return caffeineBuilder.build();
        }
        return null;
    }

    public static boolean isValid(URI uri) {
        return !JedisURIHelper.isEmpty(uri.getScheme()) && !JedisURIHelper.isEmpty(uri.getHost()) && uri.getPort() != -1;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isRedisScheme(URI uri) {
        return REDIS.equals(uri.getScheme());
    }

    public static boolean isRedisSSLScheme(URI uri) {
        return REDISS.equals(uri.getScheme());
    }
}

