/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.util.SafeEncoder;

public abstract class ClientSideCache {
    protected static final int DEFAULT_MAXIMUM_SIZE = 10000;
    protected static final int DEFAULT_EXPIRE_SECONDS = 100;
    private final Map<ByteBuffer, Set<Long>> keyToCommandHashes = new ConcurrentHashMap<ByteBuffer, Set<Long>>();

    protected ClientSideCache() {
    }

    protected abstract void invalidateAllCommandHashes();

    protected abstract void invalidateCommandHashes(Iterable<Long> var1);

    protected abstract void put(long var1, Object var3);

    protected abstract Object get(long var1);

    protected abstract long getCommandHash(CommandObject var1);

    public final void clear() {
        this.invalidateAllKeysAndCommandHashes();
    }

    final void invalidate(List list) {
        if (list == null) {
            this.invalidateAllKeysAndCommandHashes();
            return;
        }
        list.forEach(this::invalidateKeyAndRespectiveCommandHashes);
    }

    private void invalidateAllKeysAndCommandHashes() {
        this.invalidateAllCommandHashes();
        this.keyToCommandHashes.clear();
    }

    private void invalidateKeyAndRespectiveCommandHashes(Object key) {
        if (!(key instanceof byte[])) {
            throw new AssertionError((Object)("" + key.getClass().getSimpleName() + " is not supported. Value: " + String.valueOf(key)));
        }
        ByteBuffer mapKey = ClientSideCache.makeKeyForKeyToCommandHashes((byte[])key);
        Set<Long> hashes = this.keyToCommandHashes.get(mapKey);
        if (hashes != null) {
            this.invalidateCommandHashes(hashes);
            this.keyToCommandHashes.remove(mapKey);
        }
    }

    final <T> T getValue(Function<CommandObject<T>, T> loader, CommandObject<T> command, Object ... keys) {
        long hash = this.getCommandHash(command);
        Object value = this.get(hash);
        if (value != null) {
            return (T)value;
        }
        value = loader.apply(command);
        if (value != null) {
            this.put(hash, value);
            for (Object key : keys) {
                ByteBuffer mapKey = this.makeKeyForKeyToCommandHashes(key);
                if (this.keyToCommandHashes.containsKey(mapKey)) {
                    this.keyToCommandHashes.get(mapKey).add(hash);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(hash);
                this.keyToCommandHashes.put(mapKey, set);
            }
        }
        return (T)value;
    }

    private ByteBuffer makeKeyForKeyToCommandHashes(Object key) {
        if (key instanceof byte[]) {
            return ClientSideCache.makeKeyForKeyToCommandHashes((byte[])key);
        }
        if (key instanceof String) {
            return ClientSideCache.makeKeyForKeyToCommandHashes(SafeEncoder.encode((String)key));
        }
        throw new AssertionError((Object)("" + key.getClass().getSimpleName() + " is not supported. Value: " + String.valueOf(key)));
    }

    private static ByteBuffer makeKeyForKeyToCommandHashes(byte[] b) {
        return ByteBuffer.wrap(b);
    }
}

