/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.util.IOUtils;

public class SentineledConnectionProvider
implements ConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SentineledConnectionProvider.class);
    protected static final long DEFAULT_SUBSCRIBE_RETRY_WAIT_TIME_MILLIS = 5000L;
    private volatile HostAndPort currentMaster;
    private volatile ConnectionPool pool;
    private final String masterName;
    private final JedisClientConfig masterClientConfig;
    private final GenericObjectPoolConfig<Connection> masterPoolConfig;
    protected final Collection<SentinelListener> sentinelListeners = new ArrayList<SentinelListener>();
    private final JedisClientConfig sentinelClientConfig;
    private final long subscribeRetryWaitTimeMillis;
    private final Object initPoolLock = new Object();

    public SentineledConnectionProvider(String masterName, JedisClientConfig masterClientConfig, Set<HostAndPort> sentinels, JedisClientConfig sentinelClientConfig) {
        this(masterName, masterClientConfig, null, sentinels, sentinelClientConfig);
    }

    public SentineledConnectionProvider(String masterName, JedisClientConfig masterClientConfig, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> sentinels, JedisClientConfig sentinelClientConfig) {
        this(masterName, masterClientConfig, poolConfig, sentinels, sentinelClientConfig, 5000L);
    }

    public SentineledConnectionProvider(String masterName, JedisClientConfig masterClientConfig, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> sentinels, JedisClientConfig sentinelClientConfig, long subscribeRetryWaitTimeMillis) {
        this.masterName = masterName;
        this.masterClientConfig = masterClientConfig;
        this.masterPoolConfig = poolConfig;
        this.sentinelClientConfig = sentinelClientConfig;
        this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        HostAndPort master = this.initSentinels(sentinels);
        this.initMaster(master);
    }

    @Override
    public Connection getConnection() {
        return this.pool.getResource();
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        return this.pool.getResource();
    }

    @Override
    public void close() {
        this.sentinelListeners.forEach(SentinelListener::shutdown);
        this.pool.close();
    }

    public HostAndPort getCurrentMaster() {
        return this.currentMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMaster(HostAndPort master) {
        Object object = this.initPoolLock;
        synchronized (object) {
            if (!master.equals(this.currentMaster)) {
                this.currentMaster = master;
                ConnectionPool newPool = this.masterPoolConfig != null ? new ConnectionPool(this.currentMaster, this.masterClientConfig, this.masterPoolConfig) : new ConnectionPool(this.currentMaster, this.masterClientConfig);
                ConnectionPool existingPool = this.pool;
                this.pool = newPool;
                LOG.info("Created connection pool to master at {}.", (Object)master);
                if (existingPool != null) {
                    existingPool.close();
                }
            }
        }
    }

    private HostAndPort initSentinels(Set<HostAndPort> sentinels) {
        HostAndPort master = null;
        boolean sentinelAvailable = false;
        LOG.debug("Trying to find master from available sentinels...");
        for (HostAndPort sentinel : sentinels) {
            LOG.debug("Connecting to Sentinel {}...", (Object)sentinel);
            try {
                Jedis jedis = new Jedis(sentinel, this.sentinelClientConfig);
                Throwable throwable = null;
                try {
                    List<String> masterAddr = jedis.sentinelGetMasterAddrByName(this.masterName);
                    sentinelAvailable = true;
                    if (masterAddr == null || masterAddr.size() != 2) {
                        LOG.warn("Sentinel {} is not monitoring master {}.", (Object)sentinel, (Object)this.masterName);
                        continue;
                    }
                    master = SentineledConnectionProvider.toHostAndPort(masterAddr);
                    LOG.debug("Redis master reported at {}.", (Object)master);
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (JedisException e) {
                LOG.warn("Could not get master address from {}.", (Object)sentinel, (Object)e);
            }
        }
        if (master == null) {
            if (sentinelAvailable) {
                throw new JedisException("Can connect to sentinel, but " + this.masterName + " seems to be not monitored.");
            }
            throw new JedisConnectionException("All sentinels down, cannot determine where " + this.masterName + " is running.");
        }
        LOG.info("Redis master running at {}. Starting sentinel listeners...", master);
        for (HostAndPort sentinel : sentinels) {
            SentinelListener listener = new SentinelListener(sentinel);
            listener.setDaemon(true);
            this.sentinelListeners.add(listener);
            listener.start();
        }
        return master;
    }

    private static HostAndPort toHostAndPort(List<String> masterAddr) {
        return SentineledConnectionProvider.toHostAndPort(masterAddr.get(0), masterAddr.get(1));
    }

    private static HostAndPort toHostAndPort(String hostStr, String portStr) {
        return new HostAndPort(hostStr, Integer.parseInt(portStr));
    }

    protected class SentinelListener
    extends Thread {
        protected final HostAndPort node;
        protected volatile Jedis sentinelJedis;
        protected AtomicBoolean running;

        public SentinelListener(HostAndPort node) {
            super(String.format("%s-SentinelListener-[%s]", SentineledConnectionProvider.this.masterName, node.toString()));
            this.running = new AtomicBoolean(false);
            this.node = node;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                try {
                    if (!this.running.get()) break;
                    this.sentinelJedis = new Jedis(this.node, SentineledConnectionProvider.this.sentinelClientConfig);
                    List<String> masterAddr = this.sentinelJedis.sentinelGetMasterAddrByName(SentineledConnectionProvider.this.masterName);
                    if (masterAddr == null || masterAddr.size() != 2) {
                        LOG.warn("Can not get master {} address. Sentinel: {}.", (Object)SentineledConnectionProvider.this.masterName, (Object)this.node);
                    } else {
                        SentineledConnectionProvider.this.initMaster(SentineledConnectionProvider.toHostAndPort(masterAddr));
                    }
                    this.sentinelJedis.subscribe(new JedisPubSub(){

                        @Override
                        public void onMessage(String channel, String message) {
                            LOG.debug("Sentinel {} published: {}.", (Object)SentinelListener.this.node, (Object)message);
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                if (SentineledConnectionProvider.this.masterName.equals(switchMasterMsg[0])) {
                                    SentineledConnectionProvider.this.initMaster(SentineledConnectionProvider.toHostAndPort(switchMasterMsg[3], switchMasterMsg[4]));
                                } else {
                                    LOG.debug("Ignoring message on +switch-master for master {}. Our master is {}.", (Object)switchMasterMsg[0], (Object)SentineledConnectionProvider.this.masterName);
                                }
                            } else {
                                LOG.error("Invalid message received on sentinel {} on channel +switch-master: {}.", (Object)SentinelListener.this.node, (Object)message);
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisException e) {
                    if (this.running.get()) {
                        LOG.error("Lost connection to sentinel {}. Sleeping {}ms and retrying.", new Object[]{this.node, SentineledConnectionProvider.this.subscribeRetryWaitTimeMillis, e});
                        try {
                            Thread.sleep(SentineledConnectionProvider.this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException se) {
                            LOG.error("Sleep interrupted.", (Throwable)se);
                        }
                        continue;
                    }
                    LOG.debug("Unsubscribing from sentinel {}.", (Object)this.node);
                }
                finally {
                    IOUtils.closeQuietly(this.sentinelJedis);
                }
            }
        }

        public void shutdown() {
            try {
                LOG.debug("Shutting down listener on {}.", (Object)this.node);
                this.running.set(false);
                if (this.sentinelJedis != null) {
                    this.sentinelJedis.close();
                }
            }
            catch (RuntimeException e) {
                LOG.error("Error while shutting down.", (Throwable)e);
            }
        }
    }
}

