/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public abstract class JedisShardedPubSubBase<T> {
    private int subscribedChannels = 0;
    private volatile Connection client;

    public void onSMessage(T channel, T message) {
    }

    public void onSSubscribe(T channel, int subscribedChannels) {
    }

    public void onSUnsubscribe(T channel, int subscribedChannels) {
    }

    private void sendAndFlushCommand(Protocol.Command command, T ... args) {
        if (this.client == null) {
            throw new JedisException(this.getClass() + " is not connected to a Connection.");
        }
        CommandArguments cargs = new CommandArguments(command).addObjects(args);
        this.client.sendCommand(cargs);
        this.client.flush();
    }

    public final void sunsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.SUNSUBSCRIBE, new Object[0]);
    }

    public final void sunsubscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.SUNSUBSCRIBE, channels);
    }

    public final void ssubscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.SSUBSCRIBE, channels);
    }

    public final boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public final int getSubscribedChannels() {
        return this.subscribedChannels;
    }

    public final void proceed(Connection client, T ... channels) {
        this.client = client;
        this.client.setTimeoutInfinite();
        try {
            this.ssubscribe(channels);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected abstract T encode(byte[] var1);

    private void process() {
        do {
            Object reply;
            if ((reply = this.client.getUnflushedObject()) instanceof List) {
                T enchannel;
                byte[] bchannel;
                List listReply = (List)reply;
                Object firstObj = listReply.get(0);
                if (!(firstObj instanceof byte[])) {
                    throw new JedisException("Unknown message type: " + firstObj);
                }
                byte[] resp = (byte[])firstObj;
                if (Arrays.equals(Protocol.ResponseKeyword.SSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSSubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.SUNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSUnsubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.SMESSAGE.getRaw(), resp)) {
                    bchannel = (byte[])listReply.get(1);
                    byte[] bmesg = (byte[])listReply.get(2);
                    T enchannel2 = bchannel == null ? null : (T)this.encode(bchannel);
                    T enmesg = bmesg == null ? null : (T)this.encode(bmesg);
                    this.onSMessage(enchannel2, enmesg);
                    continue;
                }
                System.out.println(SafeEncoder.encodeObject(resp));
                throw new JedisException("Unknown message type: " + firstObj);
            }
            throw new JedisException("Unknown message type: " + reply);
        } while (this.isSubscribed());
    }
}

