/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;

public class CommandDocument {
    private final String summary;
    private final String since;
    private final String group;
    private final String complexity;
    private final List<String> history;
    public static final Builder<CommandDocument> COMMAND_DOCUMENT_BUILDER = new Builder<CommandDocument>(){

        @Override
        public CommandDocument build(Object data) {
            List commandData = (List)data;
            String summary = BuilderFactory.STRING.build(commandData.get(1));
            String since = BuilderFactory.STRING.build(commandData.get(3));
            String group = BuilderFactory.STRING.build(commandData.get(5));
            String complexity = BuilderFactory.STRING.build(commandData.get(7));
            ArrayList<String> history = null;
            if (BuilderFactory.STRING.build(commandData.get(8)).equals("history")) {
                List rawHistory = (List)commandData.get(9);
                history = new ArrayList<String>(rawHistory.size());
                for (List timePoint : rawHistory) {
                    history.add(BuilderFactory.STRING.build(timePoint.get(0)) + ": " + BuilderFactory.STRING.build(timePoint.get(1)));
                }
            }
            return new CommandDocument(summary, since, group, complexity, history);
        }
    };

    public CommandDocument(String summary, String since, String group, String complexity, List<String> history) {
        this.summary = summary;
        this.since = since;
        this.group = group;
        this.complexity = complexity;
        this.history = history;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getSince() {
        return this.since;
    }

    public String getGroup() {
        return this.group;
    }

    public String getComplexity() {
        return this.complexity;
    }

    public List<String> getHistory() {
        return this.history;
    }
}

