/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.SentinelCommands;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.SafeEncoder;

public class Sentinel
implements SentinelCommands,
Closeable {
    protected final Connection connection;
    protected static final byte[][] DUMMY_ARRAY = new byte[0][];

    public Sentinel(String uriString) {
        this(URI.create(uriString));
    }

    public Sentinel(HostAndPort hp) {
        this.connection = new Connection(hp);
    }

    public Sentinel(String host, int port) {
        this.connection = new Connection(host, port);
    }

    public Sentinel(String host, int port, JedisClientConfig config) {
        this(new HostAndPort(host, port), config);
    }

    public Sentinel(HostAndPort hostPort, JedisClientConfig config) {
        this.connection = new Connection(hostPort, config);
    }

    public Sentinel(String host, int port, boolean ssl) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public Sentinel(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(String host, int port, int timeout) {
        this(host, port, timeout, timeout);
    }

    public Sentinel(String host, int port, int timeout, boolean ssl) {
        this(host, port, timeout, timeout, ssl);
    }

    public Sentinel(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, timeout, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Sentinel(String host, int port, int connectionTimeout, int soTimeout) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public Sentinel(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).build());
    }

    public Sentinel(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).build());
    }

    public Sentinel(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(URI uri) {
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri.toString()));
        }
        this.connection = new Connection(new HostAndPort(uri.getHost(), uri.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uri)).password(JedisURIHelper.getPassword(uri)).database(JedisURIHelper.getDBIndex(uri)).ssl(JedisURIHelper.isRedisSSLScheme(uri)).build());
    }

    public Sentinel(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(URI uri, int timeout) {
        this(uri, timeout, timeout);
    }

    public Sentinel(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, timeout, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Sentinel(URI uri, int connectionTimeout, int soTimeout) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).build());
    }

    public Sentinel(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(URI uri, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Sentinel(URI uri, JedisClientConfig config) {
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uri.toString()));
        }
        this.connection = new Connection(new HostAndPort(uri.getHost(), uri.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(config.getConnectionTimeoutMillis()).socketTimeoutMillis(config.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(config.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uri)).password(JedisURIHelper.getPassword(uri)).database(JedisURIHelper.getDBIndex(uri)).clientName(config.getClientName()).ssl(JedisURIHelper.isRedisSSLScheme(uri)).sslSocketFactory(config.getSslSocketFactory()).sslParameters(config.getSslParameters()).hostnameVerifier(config.getHostnameVerifier()).build());
    }

    public Sentinel(Connection connection) {
        this.connection = connection;
    }

    public String toString() {
        return "Sentinel{" + this.connection + '}';
    }

    public Connection getClient() {
        return this.getConnection();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void connect() {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public boolean isBroken() {
        return this.connection.isBroken();
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public String sentinelMyId() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MYID);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTERS);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> sentinelMaster(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTER.name(), masterName);
        return BuilderFactory.STRING_MAP.build(this.connection.getOne());
    }

    @Override
    public List<Map<String, String>> sentinelSentinels(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SENTINELS.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.GET_MASTER_ADDR_BY_NAME.getRaw(), SafeEncoder.encode(masterName));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public Long sentinelReset(String pattern) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.RESET.name(), pattern);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SLAVES.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, String>> sentinelReplicas(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REPLICAS.name(), masterName);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.FAILOVER.name(), masterName);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        CommandArguments args = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.MONITOR).add(masterName).add(ip).add(port).add(quorum);
        this.connection.sendCommand(args);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REMOVE.name(), masterName);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        CommandArguments args = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.SET).add(masterName);
        parameterMap.entrySet().forEach(entry -> args.add(entry.getKey()).add(entry.getValue()));
        this.connection.sendCommand(args);
        return this.connection.getStatusCodeReply();
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.connection.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.connection, channels);
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.connection.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.connection, channels);
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }
}

