/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.stream;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StreamEntryID
implements Comparable<StreamEntryID>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final StreamEntryID NEW_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "*";
        }
    };
    public static final StreamEntryID LAST_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "$";
        }
    };
    public static final StreamEntryID UNRECEIVED_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return ">";
        }
    };
    private long time;
    private long sequence;

    public StreamEntryID() {
        this(0L, 0L);
    }

    public StreamEntryID(String id) {
        String[] split = id.split("-");
        this.time = Long.parseLong(split[0]);
        this.sequence = Long.parseLong(split[1]);
    }

    public StreamEntryID(long time, long sequence) {
        this.time = time;
        this.sequence = sequence;
    }

    public String toString() {
        return this.time + "-" + this.sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamEntryID other = (StreamEntryID)obj;
        return this.time == other.time && this.sequence == other.sequence;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(StreamEntryID other) {
        int timeComapre = Long.compare(this.time, other.time);
        return timeComapre != 0 ? timeComapre : Long.compare(this.sequence, other.sequence);
    }

    public long getTime() {
        return this.time;
    }

    public long getSequence() {
        return this.sequence;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.time);
        out.writeLong(this.sequence);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.time = in.readLong();
        this.sequence = in.readLong();
    }
}

