/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class XAddParams
implements IParams {
    private String id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(String id) {
        this.id = id;
        return this;
    }

    public XAddParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XAddParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.nomkstream) {
            args.add(Protocol.Keyword.NOMKSTREAM.getRaw());
        }
        if (this.maxLen != null) {
            args.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            args.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            args.add(Protocol.Keyword.LIMIT.getRaw());
            args.add(Protocol.toByteArray(this.limit));
        }
        if (this.id != null) {
            args.add(SafeEncoder.encode(this.id));
        } else {
            args.add(Protocol.BYTES_ASTERISK);
        }
    }
}

