/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Response;

public abstract class MultiNodePipelineBase
implements Closeable {
    private final Map<HostAndPort, Queue<Response<?>>> pipelinedResponses = new LinkedHashMap();
    private final Map<HostAndPort, Connection> connections = new LinkedHashMap<HostAndPort, Connection>();
    private volatile boolean synced = false;

    protected abstract Connection getConnection(HostAndPort var1);

    protected final <T> Response<T> appendCommand(HostAndPort nodeKey, CommandObject<T> commandObject) {
        Connection connection;
        Queue<Object> queue;
        if (this.pipelinedResponses.containsKey(nodeKey)) {
            queue = this.pipelinedResponses.get(nodeKey);
            connection = this.connections.get(nodeKey);
        } else {
            queue = new LinkedList();
            connection = this.getConnection(nodeKey);
            this.pipelinedResponses.put(nodeKey, queue);
            this.connections.put(nodeKey, connection);
        }
        connection.sendCommand(commandObject.getArguments());
        Response<T> response = new Response<T>(commandObject.getBuilder());
        queue.add(response);
        return response;
    }

    @Override
    public final void close() {
        this.sync();
        for (Connection connection : this.connections.values()) {
            connection.close();
        }
    }

    public final void sync() {
        if (this.synced) {
            return;
        }
        for (Map.Entry<HostAndPort, Queue<Response<?>>> entry : this.pipelinedResponses.entrySet()) {
            HostAndPort nodeKey = entry.getKey();
            Queue<Response<?>> queue = entry.getValue();
            List<Object> unformatted = this.connections.get(nodeKey).getMany(queue.size());
            for (Object o : unformatted) {
                queue.poll().set(o);
            }
        }
        this.synced = true;
    }
}

