/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;
    private volatile Pool<Connection> pool;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    public void setPool(Pool<Connection> pool) {
        this.pool = pool;
    }

    public void setPassword(String password) {
        this.clientConfig.updatePassword(password);
    }

    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = (Connection)pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (RuntimeException e) {
                logger.warn("Error while QUIT", (Throwable)e);
            }
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.warn("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        if (this.pool == null) {
            throw new IllegalStateException("Pool is not set.");
        }
        Connection jedis = null;
        try {
            jedis = new Connection(this.jedisSocketFactory, this.clientConfig, this.pool);
            jedis.connect();
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (RuntimeException e) {
                    logger.warn("Error while QUIT", (Throwable)e);
                }
                try {
                    jedis.close();
                }
                catch (RuntimeException e) {
                    logger.warn("Error while close", (Throwable)e);
                }
            }
            throw je;
        }
    }

    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = (Connection)pooledConnection.getObject();
        try {
            return jedis.isConnected() && jedis.ping();
        }
        catch (Exception e) {
            logger.error("Error while validating pooled Connection object.", (Throwable)e);
            return false;
        }
    }
}

