/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.ClusterCommandArguments;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.providers.JedisConnectionProvider;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.Pool;

public class JedisClusterConnectionProvider
implements JedisConnectionProvider {
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionProvider(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig) {
        this.cache = new JedisClusterInfoCache(clientConfig);
        this.initializeSlotsCache(jedisClusterNodes, clientConfig);
    }

    public JedisClusterConnectionProvider(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this.cache = new JedisClusterInfoCache(clientConfig, poolConfig);
        this.initializeSlotsCache(jedisClusterNodes, clientConfig);
    }

    private void initializeSlotsCache(Set<HostAndPort> startNodes, JedisClientConfig clientConfig) {
        ArrayList<HostAndPort> startNodeList = new ArrayList<HostAndPort>(startNodes);
        Collections.shuffle(startNodeList);
        for (HostAndPort hostAndPort : startNodeList) {
            try (Connection jedis = new Connection(hostAndPort, clientConfig);){
                this.cache.discoverClusterNodesAndSlots(jedis);
                return;
            }
            catch (JedisConnectionException jedisConnectionException) {
            }
        }
    }

    @Override
    public void close() {
        this.cache.reset();
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public void renewSlotCache(Connection jedis) {
        this.cache.renewClusterSlots(jedis);
    }

    public Map<String, Pool<Connection>> getNodes() {
        return this.cache.getNodes();
    }

    public HostAndPort getNode(String key) {
        return this.cache.getSlotNode(JedisClusterCRC16.getSlot(key));
    }

    public HostAndPort getNode(byte[] key) {
        return this.cache.getSlotNode(JedisClusterCRC16.getSlot(key));
    }

    public Connection getConnection(HostAndPort node) {
        return this.cache.setupNodeIfNotExist(node).getResource();
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        int slot = ((ClusterCommandArguments)args).getCommandHashSlot();
        return slot >= 0 ? this.getConnectionFromSlot(slot) : this.getConnection();
    }

    public Connection getConnection() {
        List<Pool<Connection>> pools = this.cache.getShuffledNodesPool();
        JedisException suppressed = null;
        for (Pool<Connection> pool : pools) {
            Connection jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                jedis.ping();
                return jedis;
            }
            catch (JedisException ex) {
                if (suppressed == null) {
                    suppressed = ex;
                }
                if (jedis == null) continue;
                jedis.close();
            }
        }
        JedisClusterOperationException noReachableNode = new JedisClusterOperationException("No reachable node in cluster.");
        if (suppressed != null) {
            noReachableNode.addSuppressed(suppressed);
        }
        throw noReachableNode;
    }

    public Connection getConnectionFromSlot(int slot) {
        Pool<Connection> connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.renewSlotCache();
        connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }
}

