/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class ZParams
implements IParams {
    private final List<byte[]> params = new ArrayList<byte[]>();

    public ZParams weights(double ... weights) {
        this.params.add(Protocol.Keyword.WEIGHTS.getRaw());
        for (double weight : weights) {
            this.params.add(Protocol.toByteArray(weight));
        }
        return this;
    }

    public ZParams aggregate(Aggregate aggregate) {
        this.params.add(Protocol.Keyword.AGGREGATE.getRaw());
        this.params.add(aggregate.raw);
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        this.params.forEach(param -> args.add(param));
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

        @Deprecated
        public final byte[] raw = SafeEncoder.encode(this.name());

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

