/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.stream.StreamEntryID;
import redis.clients.jedis.util.SafeEncoder;

public class XPendingParams
implements IParams {
    private Long idle;
    private String consumer;
    private StreamEntryID start;
    private StreamEntryID end;
    private Integer count;

    public static XPendingParams xPendingParams() {
        return new XPendingParams();
    }

    public XPendingParams idle(long idle) {
        this.idle = idle;
        return this;
    }

    public XPendingParams start(StreamEntryID start) {
        this.start = start;
        return this;
    }

    public XPendingParams end(StreamEntryID end) {
        this.end = end;
        return this;
    }

    public XPendingParams count(int count) {
        this.count = count;
        return this;
    }

    public XPendingParams consumer(String consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.idle != null) {
            args.add(Protocol.Keyword.IDLE.getRaw());
            args.add(Protocol.toByteArray(this.idle));
        }
        if (this.start == null) {
            args.add(SafeEncoder.encode("-"));
        } else {
            args.add(SafeEncoder.encode(this.start.toString()));
        }
        if (this.end == null) {
            args.add(SafeEncoder.encode("+"));
        } else {
            args.add(SafeEncoder.encode(this.end.toString()));
        }
        if (this.count != null) {
            args.add(Protocol.toByteArray(this.count));
        }
        if (this.consumer != null) {
            args.add(SafeEncoder.encode(this.consumer));
        }
    }
}

