/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.params.Params;

public class SetParams
extends Params
implements IParams {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String KEEPTTL = "keepttl";
    private static final String GET = "get";

    public static SetParams setParams() {
        return new SetParams();
    }

    @Deprecated
    public SetParams ex(int secondsToExpire) {
        return this.ex((long)secondsToExpire);
    }

    public SetParams ex(long secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public SetParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public SetParams nx() {
        this.addParam(NX);
        return this;
    }

    public SetParams xx() {
        this.addParam(XX);
        return this;
    }

    public SetParams exAt(long seconds) {
        this.addParam(EXAT, seconds);
        return this;
    }

    public SetParams pxAt(long milliseconds) {
        this.addParam(PXAT, milliseconds);
        return this;
    }

    public SetParams keepttl() {
        this.addParam(KEEPTTL);
        return this;
    }

    public SetParams get() {
        this.addParam(GET);
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.contains(NX)) {
            args.add(Protocol.Keyword.NX);
        }
        if (this.contains(XX)) {
            args.add(Protocol.Keyword.XX);
        }
        if (this.contains(EX)) {
            args.add(Protocol.Keyword.EX);
            args.add(Protocol.toByteArray((Long)this.getParam(EX)));
        }
        if (this.contains(PX)) {
            args.add(Protocol.Keyword.PX);
            args.add(Protocol.toByteArray((Long)this.getParam(PX)));
        }
        if (this.contains(EXAT)) {
            args.add(Protocol.Keyword.EXAT);
            args.add(Protocol.toByteArray((Long)this.getParam(EXAT)));
        }
        if (this.contains(PXAT)) {
            args.add(Protocol.Keyword.PXAT);
            args.add(Protocol.toByteArray((Long)this.getParam(PXAT)));
        }
        if (this.contains(KEEPTTL)) {
            args.add(Protocol.Keyword.KEEPTTL);
        }
        if (this.contains(GET)) {
            args.add(Protocol.Keyword.GET);
        }
    }
}

