/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.commands.Commands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;

public class Client
extends BinaryClient
implements Commands {
    public Client() {
    }

    @Deprecated
    public Client(String host) {
        super(host);
    }

    public Client(String host, int port) {
        super(host, port);
    }

    @Deprecated
    public Client(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    @Deprecated
    public Client(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Client(HostAndPort hostPort, JedisClientConfig clientConfig) {
        super(hostPort, clientConfig);
    }

    public Client(JedisSocketFactory jedisSocketFactory) {
        super(jedisSocketFactory);
    }

    @Override
    public void copy(String srcKey, String dstKey, int db, boolean replace) {
        this.copy(SafeEncoder.encode(srcKey), SafeEncoder.encode(dstKey), db, replace);
    }

    @Override
    public void copy(String srcKey, String dstKey, boolean replace) {
        this.copy(SafeEncoder.encode(srcKey), SafeEncoder.encode(dstKey), replace);
    }

    @Override
    public void ping(String message) {
        this.ping(SafeEncoder.encode(message));
    }

    @Override
    public void set(String key, String value) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void set(String key, String value, SetParams params) {
        this.set(SafeEncoder.encode(key), SafeEncoder.encode(value), params);
    }

    @Override
    public void get(String key) {
        this.get(SafeEncoder.encode(key));
    }

    @Override
    public void getDel(String key) {
        this.getDel(SafeEncoder.encode(key));
    }

    @Override
    public void getEx(String key, GetExParams params) {
        this.getEx(SafeEncoder.encode(key), params);
    }

    @Override
    public void exists(String ... keys) {
        this.exists(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void del(String ... keys) {
        this.del(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void unlink(String ... keys) {
        this.unlink(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void type(String key) {
        this.type(SafeEncoder.encode(key));
    }

    @Override
    public void keys(String pattern) {
        this.keys(SafeEncoder.encode(pattern));
    }

    @Override
    public void rename(String oldkey, String newkey) {
        this.rename(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void renamenx(String oldkey, String newkey) {
        this.renamenx(SafeEncoder.encode(oldkey), SafeEncoder.encode(newkey));
    }

    @Override
    public void expire(String key, long seconds) {
        this.expire(SafeEncoder.encode(key), seconds);
    }

    @Override
    public void expireAt(String key, long unixTime) {
        this.expireAt(SafeEncoder.encode(key), unixTime);
    }

    @Override
    public void ttl(String key) {
        this.ttl(SafeEncoder.encode(key));
    }

    @Override
    public void touch(String ... keys) {
        this.touch(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void move(String key, int dbIndex) {
        this.move(SafeEncoder.encode(key), dbIndex);
    }

    @Override
    public void getSet(String key, String value) {
        this.getSet(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void mget(String ... keys) {
        this.mget(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void setnx(String key, String value) {
        this.setnx(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void setex(String key, long seconds, String value) {
        this.setex(SafeEncoder.encode(key), seconds, SafeEncoder.encode(value));
    }

    @Override
    public void mset(String ... keysvalues) {
        this.mset(SafeEncoder.encodeMany(keysvalues));
    }

    @Override
    public void msetnx(String ... keysvalues) {
        this.msetnx(SafeEncoder.encodeMany(keysvalues));
    }

    @Override
    public void decrBy(String key, long decrement) {
        this.decrBy(SafeEncoder.encode(key), decrement);
    }

    @Override
    public void decr(String key) {
        this.decr(SafeEncoder.encode(key));
    }

    @Override
    public void incrBy(String key, long increment) {
        this.incrBy(SafeEncoder.encode(key), increment);
    }

    @Override
    public void incr(String key) {
        this.incr(SafeEncoder.encode(key));
    }

    @Override
    public void append(String key, String value) {
        this.append(SafeEncoder.encode(key), SafeEncoder.encode(value));
    }

    @Override
    public void substr(String key, int start, int end) {
        this.substr(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void hset(String key, String field, String value) {
        this.hset(SafeEncoder.encode(key), SafeEncoder.encode(field), SafeEncoder.encode(value));
    }

    @Override
    public void hset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue()));
        }
        this.hset(SafeEncoder.encode(key), bhash);
    }

    @Override
    public void hget(String key, String field) {
        this.hget(SafeEncoder.encode(key), SafeEncoder.encode(field));
    }

    @Override
    public void hsetnx(String key, String field, String value) {
        this.hsetnx(SafeEncoder.encode(key), SafeEncoder.encode(field), SafeEncoder.encode(value));
    }

    @Override
    public void hmset(String key, Map<String, String> hash) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue()));
        }
        this.hmset(SafeEncoder.encode(key), bhash);
    }

    @Override
    public void hmget(String key, String ... fields) {
        this.hmget(SafeEncoder.encode(key), SafeEncoder.encodeMany(fields));
    }

    @Override
    public void hincrBy(String key, String field, long value) {
        this.hincrBy(SafeEncoder.encode(key), SafeEncoder.encode(field), value);
    }

    @Override
    public void hexists(String key, String field) {
        this.hexists(SafeEncoder.encode(key), SafeEncoder.encode(field));
    }

    @Override
    public void hdel(String key, String ... fields) {
        this.hdel(SafeEncoder.encode(key), SafeEncoder.encodeMany(fields));
    }

    @Override
    public void hlen(String key) {
        this.hlen(SafeEncoder.encode(key));
    }

    @Override
    public void hkeys(String key) {
        this.hkeys(SafeEncoder.encode(key));
    }

    @Override
    public void hvals(String key) {
        this.hvals(SafeEncoder.encode(key));
    }

    @Override
    public void hgetAll(String key) {
        this.hgetAll(SafeEncoder.encode(key));
    }

    @Override
    public void hrandfield(String key) {
        this.hrandfield(SafeEncoder.encode(key));
    }

    @Override
    public void hrandfield(String key, long count) {
        this.hrandfield(SafeEncoder.encode(key), count);
    }

    @Override
    public void hrandfieldWithValues(String key, long count) {
        this.hrandfieldWithValues(SafeEncoder.encode(key), count);
    }

    @Override
    public void rpush(String key, String ... string) {
        this.rpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void lpush(String key, String ... string) {
        this.lpush(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void llen(String key) {
        this.llen(SafeEncoder.encode(key));
    }

    @Override
    public void lrange(String key, long start, long stop) {
        this.lrange(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void ltrim(String key, long start, long stop) {
        this.ltrim(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void lindex(String key, long index) {
        this.lindex(SafeEncoder.encode(key), index);
    }

    @Override
    public void lset(String key, long index, String value) {
        this.lset(SafeEncoder.encode(key), index, SafeEncoder.encode(value));
    }

    @Override
    public void lrem(String key, long count, String value) {
        this.lrem(SafeEncoder.encode(key), count, SafeEncoder.encode(value));
    }

    @Override
    public void lpop(String key) {
        this.lpop(SafeEncoder.encode(key));
    }

    @Override
    public void lpop(String key, int count) {
        this.lpop(SafeEncoder.encode(key), count);
    }

    @Override
    public void lpos(String key, String element) {
        this.lpos(SafeEncoder.encode(key), SafeEncoder.encode(element));
    }

    @Override
    public void lpos(String key, String element, LPosParams params) {
        this.lpos(SafeEncoder.encode(key), SafeEncoder.encode(element), params);
    }

    @Override
    public void lpos(String key, String element, LPosParams params, long count) {
        this.lpos(SafeEncoder.encode(key), SafeEncoder.encode(element), params, count);
    }

    @Override
    public void rpop(String key) {
        this.rpop(SafeEncoder.encode(key));
    }

    @Override
    public void rpop(String key, int count) {
        this.rpop(SafeEncoder.encode(key), count);
    }

    @Override
    public void rpoplpush(String srckey, String dstkey) {
        this.rpoplpush(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey));
    }

    @Override
    public void sadd(String key, String ... members) {
        this.sadd(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void smembers(String key) {
        this.smembers(SafeEncoder.encode(key));
    }

    @Override
    public void srem(String key, String ... members) {
        this.srem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void spop(String key) {
        this.spop(SafeEncoder.encode(key));
    }

    @Override
    public void spop(String key, long count) {
        this.spop(SafeEncoder.encode(key), count);
    }

    @Override
    public void smove(String srckey, String dstkey, String member) {
        this.smove(SafeEncoder.encode(srckey), SafeEncoder.encode(dstkey), SafeEncoder.encode(member));
    }

    @Override
    public void scard(String key) {
        this.scard(SafeEncoder.encode(key));
    }

    @Override
    public void sismember(String key, String member) {
        this.sismember(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void smismember(String key, String ... members) {
        this.smismember(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void sinter(String ... keys) {
        this.sinter(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sinterstore(String dstkey, String ... keys) {
        this.sinterstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sunion(String ... keys) {
        this.sunion(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sunionstore(String dstkey, String ... keys) {
        this.sunionstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sdiff(String ... keys) {
        this.sdiff(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sdiffstore(String dstkey, String ... keys) {
        this.sdiffstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void srandmember(String key) {
        this.srandmember(SafeEncoder.encode(key));
    }

    @Override
    public void zadd(String key, double score, String member) {
        this.zadd(SafeEncoder.encode(key), score, SafeEncoder.encode(member));
    }

    @Override
    public void zadd(String key, double score, String member, ZAddParams params) {
        this.zadd(SafeEncoder.encode(key), score, SafeEncoder.encode(member), params);
    }

    @Override
    public void zadd(String key, Map<String, Double> scoreMembers) {
        HashMap<byte[], Double> binaryScoreMembers = this.convertScoreMembersToBinary(scoreMembers);
        this.zadd(SafeEncoder.encode(key), binaryScoreMembers);
    }

    @Override
    public void zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        HashMap<byte[], Double> binaryScoreMembers = this.convertScoreMembersToBinary(scoreMembers);
        this.zadd(SafeEncoder.encode(key), binaryScoreMembers, params);
    }

    @Override
    public void zaddIncr(String key, double score, String member, ZAddParams params) {
        this.zaddIncr(SafeEncoder.encode(key), score, SafeEncoder.encode(member), params);
    }

    @Override
    public void zdiff(String ... keys) {
        this.zdiff(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zdiffWithScores(String ... keys) {
        this.zdiffWithScores(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zrange(String key, long start, long stop) {
        this.zrange(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void zrem(String key, String ... members) {
        this.zrem(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void zincrby(String key, double increment, String member) {
        this.zincrby(SafeEncoder.encode(key), increment, SafeEncoder.encode(member));
    }

    @Override
    public void zincrby(String key, double increment, String member, ZIncrByParams params) {
        this.zincrby(SafeEncoder.encode(key), increment, SafeEncoder.encode(member), params);
    }

    @Override
    public void zrank(String key, String member) {
        this.zrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrank(String key, String member) {
        this.zrevrank(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zrevrange(String key, long start, long stop) {
        this.zrevrange(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void zrangeWithScores(String key, long start, long stop) {
        this.zrangeWithScores(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void zrevrangeWithScores(String key, long start, long stop) {
        this.zrevrangeWithScores(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void zrandmember(String key) {
        this.zrandmember(SafeEncoder.encode(key));
    }

    @Override
    public void zrandmember(String key, long count) {
        this.zrandmember(SafeEncoder.encode(key), count);
    }

    @Override
    public void zrandmemberWithScores(String key, long count) {
        this.zrandmemberWithScores(SafeEncoder.encode(key), count);
    }

    @Override
    public void zcard(String key) {
        this.zcard(SafeEncoder.encode(key));
    }

    @Override
    public void zscore(String key, String member) {
        this.zscore(SafeEncoder.encode(key), SafeEncoder.encode(member));
    }

    @Override
    public void zmscore(String key, String ... members) {
        this.zmscore(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    @Override
    public void zpopmax(String key) {
        this.zpopmax(SafeEncoder.encode(key));
    }

    @Override
    public void zpopmax(String key, int count) {
        this.zpopmax(SafeEncoder.encode(key), count);
    }

    @Override
    public void zpopmin(String key) {
        this.zpopmin(SafeEncoder.encode(key));
    }

    @Override
    public void zpopmin(String key, long count) {
        this.zpopmin(SafeEncoder.encode(key), count);
    }

    @Override
    public void watch(String ... keys) {
        this.watch(SafeEncoder.encodeMany(keys));
    }

    @Override
    public void sort(String key) {
        this.sort(SafeEncoder.encode(key));
    }

    @Override
    public void sort(String key, SortingParams sortingParameters) {
        this.sort(SafeEncoder.encode(key), sortingParameters);
    }

    @Override
    public void sort(String key, SortingParams sortingParameters, String dstkey) {
        this.sort(SafeEncoder.encode(key), sortingParameters, SafeEncoder.encode(dstkey));
    }

    @Override
    public void sort(String key, String dstkey) {
        this.sort(SafeEncoder.encode(key), SafeEncoder.encode(dstkey));
    }

    @Override
    public void lmove(String srcKey, String dstKey, ListDirection from, ListDirection to) {
        this.lmove(SafeEncoder.encode(srcKey), SafeEncoder.encode(dstKey), from, to);
    }

    @Override
    public void blmove(String srcKey, String dstKey, ListDirection from, ListDirection to, double timeout) {
        this.blmove(SafeEncoder.encode(srcKey), SafeEncoder.encode(dstKey), from, to, timeout);
    }

    @Override
    public void blpop(String[] args) {
        this.blpop(SafeEncoder.encodeMany(args));
    }

    @Override
    public void blpop(int timeout, String ... keys) {
        this.blpop(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void blpop(double timeout, String ... keys) {
        this.blpop(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void brpop(String[] args) {
        this.brpop(SafeEncoder.encodeMany(args));
    }

    @Override
    public void brpop(int timeout, String ... keys) {
        this.brpop(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void brpop(double timeout, String ... keys) {
        this.brpop(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void bzpopmax(double timeout, String ... keys) {
        this.bzpopmax(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void bzpopmin(double timeout, String ... keys) {
        this.bzpopmin(timeout, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zcount(String key, double min, double max) {
        this.zcount(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zcount(String key, String min, String max) {
        this.zcount(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zdiffStore(String dstkey, String ... keys) {
        this.zdiffStore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zrangeByScore(String key, double min, double max) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zrangeByScore(String key, String min, String max) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zrangeByScore(String key, double min, double max, int offset, int count) {
        this.zrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min, double max) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max), offset, count);
    }

    @Override
    public void zrevrangeByScore(String key, double max, double min) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public void zrangeByScore(String key, String min, String max, int offset, int count) {
        this.zrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max), offset, count);
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.zrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max), offset, count);
    }

    @Override
    public void zrevrangeByScore(String key, String max, String min) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min));
    }

    @Override
    public void zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.zrevrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public void zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.zrevrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min), offset, count);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max, double min) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min));
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), Protocol.toByteArray(max), Protocol.toByteArray(min), offset, count);
    }

    @Override
    public void zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.zrevrangeByScoreWithScores(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min), offset, count);
    }

    @Override
    public void zremrangeByRank(String key, long start, long stop) {
        this.zremrangeByRank(SafeEncoder.encode(key), start, stop);
    }

    @Override
    public void zremrangeByScore(String key, double min, double max) {
        this.zremrangeByScore(SafeEncoder.encode(key), Protocol.toByteArray(min), Protocol.toByteArray(max));
    }

    @Override
    public void zremrangeByScore(String key, String min, String max) {
        this.zremrangeByScore(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void zunion(ZParams params, String ... keys) {
        this.zunion(params, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zunionWithScores(ZParams params, String ... keys) {
        this.zunionWithScores(params, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zunionstore(String dstkey, String ... sets) {
        this.zunionstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zunionstore(String dstkey, ZParams params, String ... sets) {
        this.zunionstore(SafeEncoder.encode(dstkey), params, SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zinter(ZParams params, String ... keys) {
        this.zinter(params, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zinterWithScores(ZParams params, String ... keys) {
        this.zinterWithScores(params, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void zinterstore(String dstkey, String ... sets) {
        this.zinterstore(SafeEncoder.encode(dstkey), SafeEncoder.encodeMany(sets));
    }

    @Override
    public void zinterstore(String dstkey, ZParams params, String ... sets) {
        this.zinterstore(SafeEncoder.encode(dstkey), params, SafeEncoder.encodeMany(sets));
    }

    public void zlexcount(String key, String min, String max) {
        this.zlexcount(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    public void zrangeByLex(String key, String min, String max) {
        this.zrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    public void zrangeByLex(String key, String min, String max, int offset, int count) {
        this.zrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max), offset, count);
    }

    public void zrevrangeByLex(String key, String max, String min) {
        this.zrevrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min));
    }

    public void zrevrangeByLex(String key, String max, String min, int offset, int count) {
        this.zrevrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(max), SafeEncoder.encode(min), offset, count);
    }

    public void zremrangeByLex(String key, String min, String max) {
        this.zremrangeByLex(SafeEncoder.encode(key), SafeEncoder.encode(min), SafeEncoder.encode(max));
    }

    @Override
    public void strlen(String key) {
        this.strlen(SafeEncoder.encode(key));
    }

    @Override
    public void lpushx(String key, String ... string) {
        this.lpushx(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void persist(String key) {
        this.persist(SafeEncoder.encode(key));
    }

    @Override
    public void rpushx(String key, String ... string) {
        this.rpushx(SafeEncoder.encode(key), SafeEncoder.encodeMany(string));
    }

    @Override
    public void echo(String string) {
        this.echo(SafeEncoder.encode(string));
    }

    @Override
    public void linsert(String key, ListPosition where, String pivot, String value) {
        this.linsert(SafeEncoder.encode(key), where, SafeEncoder.encode(pivot), SafeEncoder.encode(value));
    }

    @Override
    public void brpoplpush(String source, String destination, int timeout) {
        this.brpoplpush(SafeEncoder.encode(source), SafeEncoder.encode(destination), timeout);
    }

    @Override
    public void setbit(String key, long offset, boolean value) {
        this.setbit(SafeEncoder.encode(key), offset, value);
    }

    @Override
    public void setbit(String key, long offset, String value) {
        this.setbit(SafeEncoder.encode(key), offset, SafeEncoder.encode(value));
    }

    @Override
    public void getbit(String key, long offset) {
        this.getbit(SafeEncoder.encode(key), offset);
    }

    public void bitpos(String key, boolean value, BitPosParams params) {
        this.bitpos(SafeEncoder.encode(key), value, params);
    }

    @Override
    public void setrange(String key, long offset, String value) {
        this.setrange(SafeEncoder.encode(key), offset, SafeEncoder.encode(value));
    }

    @Override
    public void getrange(String key, long startOffset, long endOffset) {
        this.getrange(SafeEncoder.encode(key), startOffset, endOffset);
    }

    public void publish(String channel, String message) {
        this.publish(SafeEncoder.encode(channel), SafeEncoder.encode(message));
    }

    public void unsubscribe(String ... channels) {
        this.unsubscribe(SafeEncoder.encodeMany(channels));
    }

    public void psubscribe(String ... patterns) {
        this.psubscribe(SafeEncoder.encodeMany(patterns));
    }

    public void punsubscribe(String ... patterns) {
        this.punsubscribe(SafeEncoder.encodeMany(patterns));
    }

    public void subscribe(String ... channels) {
        this.subscribe(SafeEncoder.encodeMany(channels));
    }

    public void pubsubChannels(String pattern) {
        this.pubsub("channels", pattern);
    }

    public void pubsubNumPat() {
        this.pubsub("numpat", new String[0]);
    }

    public void pubsubNumSub(String ... channels) {
        this.pubsub("numsub", channels);
    }

    @Override
    public void configSet(String parameter, String value) {
        this.configSet(SafeEncoder.encode(parameter), SafeEncoder.encode(value));
    }

    @Override
    public void configGet(String pattern) {
        this.configGet(SafeEncoder.encode(pattern));
    }

    public void eval(String script, int keyCount, String ... params) {
        this.eval(SafeEncoder.encode(script), Protocol.toByteArray(keyCount), SafeEncoder.encodeMany(params));
    }

    public void evalsha(String sha1, int keyCount, String ... params) {
        this.evalsha(SafeEncoder.encode(sha1), Protocol.toByteArray(keyCount), SafeEncoder.encodeMany(params));
    }

    public void scriptExists(String ... sha1) {
        this.scriptExists(SafeEncoder.encodeMany(sha1));
    }

    public void scriptLoad(String script) {
        this.scriptLoad(SafeEncoder.encode(script));
    }

    @Override
    public void objectRefcount(String key) {
        this.objectRefcount(SafeEncoder.encode(key));
    }

    @Override
    public void objectIdletime(String key) {
        this.objectIdletime(SafeEncoder.encode(key));
    }

    @Override
    public void objectEncoding(String key) {
        this.objectEncoding(SafeEncoder.encode(key));
    }

    @Override
    public void objectFreq(String key) {
        this.objectFreq(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key) {
        this.bitcount(SafeEncoder.encode(key));
    }

    @Override
    public void bitcount(String key, long start, long end) {
        this.bitcount(SafeEncoder.encode(key), start, end);
    }

    @Override
    public void bitop(BitOP op, String destKey, String ... srcKeys) {
        this.bitop(op, SafeEncoder.encode(destKey), SafeEncoder.encodeMany(srcKeys));
    }

    public void sentinel(String ... args) {
        this.sentinel(SafeEncoder.encodeMany(args));
    }

    @Override
    public void dump(String key) {
        this.dump(SafeEncoder.encode(key));
    }

    @Override
    public void restore(String key, long ttl, byte[] serializedValue) {
        this.restore(SafeEncoder.encode(key), ttl, serializedValue);
    }

    @Override
    public void restoreReplace(String key, long ttl, byte[] serializedValue) {
        this.restoreReplace(SafeEncoder.encode(key), ttl, serializedValue);
    }

    @Override
    public void restore(String key, long ttl, byte[] serializedValue, RestoreParams params) {
        this.restore(SafeEncoder.encode(key), ttl, serializedValue, params);
    }

    public void pexpire(String key, long milliseconds) {
        this.pexpire(SafeEncoder.encode(key), milliseconds);
    }

    public void pexpireAt(String key, long millisecondsTimestamp) {
        this.pexpireAt(SafeEncoder.encode(key), millisecondsTimestamp);
    }

    @Override
    public void pttl(String key) {
        this.pttl(SafeEncoder.encode(key));
    }

    @Override
    public void incrByFloat(String key, double increment) {
        this.incrByFloat(SafeEncoder.encode(key), increment);
    }

    public void psetex(String key, long milliseconds, String value) {
        this.psetex(SafeEncoder.encode(key), milliseconds, SafeEncoder.encode(value));
    }

    public void srandmember(String key, int count) {
        this.srandmember(SafeEncoder.encode(key), count);
    }

    public void memoryUsage(String key) {
        this.memoryUsage(SafeEncoder.encode(key));
    }

    public void memoryUsage(String key, int samples) {
        this.memoryUsage(SafeEncoder.encode(key), samples);
    }

    @Override
    public void clientKill(String ipPort) {
        this.clientKill(SafeEncoder.encode(ipPort));
    }

    @Override
    public void clientSetname(String name) {
        this.clientSetname(SafeEncoder.encode(name));
    }

    @Override
    public void migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.migrate(host, port, SafeEncoder.encode(key), destinationDb, timeout);
    }

    @Override
    public void migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, String ... keys) {
        this.migrate(host, port, destinationDB, timeout, params, SafeEncoder.encodeMany(keys));
    }

    @Override
    public void hincrByFloat(String key, String field, double increment) {
        this.hincrByFloat(SafeEncoder.encode(key), SafeEncoder.encode(field), increment);
    }

    @Override
    public void scan(String cursor, ScanParams params) {
        this.scan(SafeEncoder.encode(cursor), params);
    }

    @Override
    public void hscan(String key, String cursor, ScanParams params) {
        this.hscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    @Override
    public void sscan(String key, String cursor, ScanParams params) {
        this.sscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    @Override
    public void zscan(String key, String cursor, ScanParams params) {
        this.zscan(SafeEncoder.encode(key), SafeEncoder.encode(cursor), params);
    }

    public void cluster(String subcommand, int ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = Protocol.toByteArray(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void pubsub(String subcommand, String ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.pubsub(arg);
    }

    public void cluster(String subcommand, String ... args) {
        byte[][] arg = new byte[args.length + 1][];
        for (int i = 1; i < arg.length; ++i) {
            arg[i] = SafeEncoder.encode(args[i - 1]);
        }
        arg[0] = SafeEncoder.encode(subcommand);
        this.cluster(arg);
    }

    public void cluster(String subcommand) {
        byte[][] arg = new byte[][]{SafeEncoder.encode(subcommand)};
        this.cluster(arg);
    }

    public void clusterNodes() {
        this.cluster("nodes");
    }

    public void clusterMeet(String ip, int port) {
        this.cluster("meet", ip, String.valueOf(port));
    }

    public void clusterReset(ClusterReset resetType) {
        this.cluster("reset", resetType.name());
    }

    public void clusterAddSlots(int ... slots) {
        this.cluster("addslots", slots);
    }

    public void clusterDelSlots(int ... slots) {
        this.cluster("delslots", slots);
    }

    public void clusterInfo() {
        this.cluster("info");
    }

    public void clusterGetKeysInSlot(int slot, int count) {
        int[] args = new int[]{slot, count};
        this.cluster("getkeysinslot", args);
    }

    public void clusterSetSlotNode(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "node", nodeId);
    }

    public void clusterSetSlotMigrating(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "migrating", nodeId);
    }

    public void clusterSetSlotImporting(int slot, String nodeId) {
        this.cluster("setslot", String.valueOf(slot), "importing", nodeId);
    }

    public void pfadd(String key, String ... elements) {
        this.pfadd(SafeEncoder.encode(key), SafeEncoder.encodeMany(elements));
    }

    public void pfcount(String key) {
        this.pfcount(SafeEncoder.encode(key));
    }

    public void pfcount(String ... keys) {
        this.pfcount(SafeEncoder.encodeMany(keys));
    }

    public void pfmerge(String destkey, String ... sourcekeys) {
        this.pfmerge(SafeEncoder.encode(destkey), SafeEncoder.encodeMany(sourcekeys));
    }

    public void clusterSetSlotStable(int slot) {
        this.cluster("setslot", String.valueOf(slot), "stable");
    }

    public void clusterForget(String nodeId) {
        this.cluster("forget", nodeId);
    }

    public void clusterFlushSlots() {
        this.cluster("flushslots");
    }

    public void clusterKeySlot(String key) {
        this.cluster("keyslot", key);
    }

    public void clusterCountKeysInSlot(int slot) {
        this.cluster("countkeysinslot", String.valueOf(slot));
    }

    public void clusterSaveConfig() {
        this.cluster("saveconfig");
    }

    public void clusterReplicate(String nodeId) {
        this.cluster("replicate", nodeId);
    }

    public void clusterSlaves(String nodeId) {
        this.cluster("slaves", nodeId);
    }

    public void clusterFailover() {
        this.cluster("failover");
    }

    public void clusterSlots() {
        this.cluster("slots");
    }

    public void geoadd(String key, double longitude, double latitude, String member) {
        this.geoadd(SafeEncoder.encode(key), longitude, latitude, SafeEncoder.encode(member));
    }

    public void geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.geoadd(SafeEncoder.encode(key), this.convertMemberCoordinateMapToBinary(memberCoordinateMap));
    }

    public void geoadd(String key, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.geoadd(SafeEncoder.encode(key), params, this.convertMemberCoordinateMapToBinary(memberCoordinateMap));
    }

    public void geodist(String key, String member1, String member2) {
        this.geodist(SafeEncoder.encode(key), SafeEncoder.encode(member1), SafeEncoder.encode(member2));
    }

    public void geodist(String key, String member1, String member2, GeoUnit unit) {
        this.geodist(SafeEncoder.encode(key), SafeEncoder.encode(member1), SafeEncoder.encode(member2), unit);
    }

    public void geohash(String key, String ... members) {
        this.geohash(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    public void geopos(String key, String[] members) {
        this.geopos(SafeEncoder.encode(key), SafeEncoder.encodeMany(members));
    }

    public void georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.georadius(SafeEncoder.encode(key), longitude, latitude, radius, unit);
    }

    public void georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.georadiusReadonly(SafeEncoder.encode(key), longitude, latitude, radius, unit);
    }

    public void georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.georadius(SafeEncoder.encode(key), longitude, latitude, radius, unit, param);
    }

    public void georadiusStore(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.georadiusStore(SafeEncoder.encode(key), longitude, latitude, radius, unit, param, storeParam);
    }

    public void georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.georadiusReadonly(SafeEncoder.encode(key), longitude, latitude, radius, unit, param);
    }

    public void georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        this.georadiusByMember(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit);
    }

    public void georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        this.georadiusByMemberReadonly(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit);
    }

    public void georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.georadiusByMember(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit, param);
    }

    public void georadiusByMemberStore(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.georadiusByMemberStore(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit, param, storeParam);
    }

    public void georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.georadiusByMemberReadonly(SafeEncoder.encode(key), SafeEncoder.encode(member), radius, unit, param);
    }

    public void moduleLoad(String path) {
        this.moduleLoad(SafeEncoder.encode(path));
    }

    public void moduleUnload(String name) {
        this.moduleUnload(SafeEncoder.encode(name));
    }

    public void aclGetUser(String name) {
        this.aclGetUser(SafeEncoder.encode(name));
    }

    public void aclSetUser(String name) {
        this.aclSetUser(SafeEncoder.encode(name));
    }

    public void aclSetUser(String name, String ... parameters) {
        this.aclSetUser(SafeEncoder.encode(name), SafeEncoder.encodeMany(parameters));
    }

    public void aclCat(String category) {
        this.aclCat(SafeEncoder.encode(category));
    }

    public void aclLog(String options) {
        this.aclLog(SafeEncoder.encode(options));
    }

    public void aclDelUser(String name) {
        this.aclDelUser(SafeEncoder.encode(name));
    }

    private HashMap<byte[], Double> convertScoreMembersToBinary(Map<String, Double> scoreMembers) {
        HashMap<byte[], Double> binaryScoreMembers = new HashMap<byte[], Double>();
        for (Map.Entry<String, Double> entry : scoreMembers.entrySet()) {
            binaryScoreMembers.put(SafeEncoder.encode(entry.getKey()), entry.getValue());
        }
        return binaryScoreMembers;
    }

    private HashMap<byte[], GeoCoordinate> convertMemberCoordinateMapToBinary(Map<String, GeoCoordinate> memberCoordinateMap) {
        HashMap<byte[], GeoCoordinate> binaryMemberCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (Map.Entry<String, GeoCoordinate> entry : memberCoordinateMap.entrySet()) {
            binaryMemberCoordinateMap.put(SafeEncoder.encode(entry.getKey()), entry.getValue());
        }
        return binaryMemberCoordinateMap;
    }

    @Override
    public void bitfield(String key, String ... arguments) {
        this.bitfield(SafeEncoder.encode(key), SafeEncoder.encodeMany(arguments));
    }

    @Override
    public void bitfieldReadonly(String key, String ... arguments) {
        this.bitfieldReadonly(SafeEncoder.encode(key), SafeEncoder.encodeMany(arguments));
    }

    @Override
    public void hstrlen(String key, String field) {
        this.hstrlen(SafeEncoder.encode(key), SafeEncoder.encode(field));
    }

    @Override
    public void xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        this.xadd(SafeEncoder.encode(key), SafeEncoder.encode(id == null ? "*" : id.toString()), Client.encodeStringMap(hash), maxLen, approximateLength);
    }

    @Override
    public void xadd(String key, Map<String, String> hash, XAddParams params) {
        this.xadd(SafeEncoder.encode(key), Client.encodeStringMap(hash), params);
    }

    private static Map<byte[], byte[]> encodeStringMap(Map<String, String> map) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue()));
        }
        return bhash;
    }

    @Override
    public void xlen(String key) {
        this.xlen(SafeEncoder.encode(key));
    }

    @Override
    public void xrange(String key, StreamEntryID start, StreamEntryID end) {
        this.xrange(SafeEncoder.encode(key), SafeEncoder.encode(start == null ? "-" : start.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()));
    }

    @Override
    public void xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        this.xrange(SafeEncoder.encode(key), SafeEncoder.encode(start == null ? "-" : start.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()), count);
    }

    @Override
    public void xrange(String key, StreamEntryID start, StreamEntryID end, long count) {
        this.xrange(SafeEncoder.encode(key), SafeEncoder.encode(start == null ? "-" : start.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()), count);
    }

    @Override
    public void xrevrange(String key, StreamEntryID end, StreamEntryID start) {
        this.xrevrange(SafeEncoder.encode(key), SafeEncoder.encode(end == null ? "+" : end.toString()), SafeEncoder.encode(start == null ? "-" : start.toString()));
    }

    @Override
    public void xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        this.xrevrange(SafeEncoder.encode(key), SafeEncoder.encode(end == null ? "+" : end.toString()), SafeEncoder.encode(start == null ? "-" : start.toString()), count);
    }

    @Override
    public void xread(int count, long block, Map.Entry<String, StreamEntryID> ... streams) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(streams.length);
        for (Map.Entry<String, StreamEntryID> entry : streams) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue() == null ? "0-0" : entry.getValue().toString()));
        }
        this.xread(count, block, bhash);
    }

    @Override
    public void xread(XReadParams params, Map<String, StreamEntryID> streams) {
        byte[][] bparams = params.getByteParams();
        int paramLength = bparams.length;
        byte[][] args = new byte[paramLength + 1 + streams.size() * 2][];
        System.arraycopy(bparams, 0, args, 0, paramLength);
        args[paramLength] = Protocol.Keyword.STREAMS.raw;
        int keyIndex = paramLength + 1;
        int idsIndex = keyIndex + streams.size();
        for (Map.Entry<String, StreamEntryID> entry : streams.entrySet()) {
            args[keyIndex++] = SafeEncoder.encode(entry.getKey());
            args[idsIndex++] = SafeEncoder.encode(entry.getValue().toString());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREAD, args);
    }

    @Override
    public void xack(String key, String group, StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            StreamEntryID id = ids[i];
            bids[i] = SafeEncoder.encode(id == null ? "0-0" : id.toString());
        }
        this.xack(SafeEncoder.encode(key), SafeEncoder.encode(group), bids);
    }

    @Override
    public void xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        this.xgroupCreate(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(id == null ? "0-0" : id.toString()), makeStream);
    }

    @Override
    public void xgroupSetID(String key, String groupname, StreamEntryID id) {
        this.xgroupSetID(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(id == null ? "0-0" : id.toString()));
    }

    @Override
    public void xgroupDestroy(String key, String groupname) {
        this.xgroupDestroy(SafeEncoder.encode(key), SafeEncoder.encode(groupname));
    }

    @Override
    public void xgroupDelConsumer(String key, String groupname, String consumerName) {
        this.xgroupDelConsumer(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(consumerName));
    }

    @Override
    public void xdel(String key, StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            StreamEntryID id = ids[i];
            bids[i] = SafeEncoder.encode(id == null ? "0-0" : id.toString());
        }
        this.xdel(SafeEncoder.encode(key), bids);
    }

    @Override
    public void xtrim(String key, long maxLen, boolean approximateLength) {
        this.xtrim(SafeEncoder.encode(key), maxLen, approximateLength);
    }

    @Override
    public void xtrim(String key, XTrimParams params) {
        this.xtrim(SafeEncoder.encode(key), params);
    }

    @Override
    public void xreadGroup(String groupname, String consumer, int count, long block, boolean noAck, Map.Entry<String, StreamEntryID> ... streams) {
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>(streams.length);
        for (Map.Entry<String, StreamEntryID> entry : streams) {
            bhash.put(SafeEncoder.encode(entry.getKey()), SafeEncoder.encode(entry.getValue() == null ? ">" : entry.getValue().toString()));
        }
        this.xreadGroup(SafeEncoder.encode(groupname), SafeEncoder.encode(consumer), count, block, noAck, bhash);
    }

    @Override
    public void xreadGroup(String groupname, String consumer, XReadGroupParams params, Map<String, StreamEntryID> streams) {
        byte[][] bparams = params.getByteParams();
        int paramLength = bparams.length;
        byte[][] args = new byte[3 + paramLength + 1 + streams.size() * 2][];
        int index = 0;
        args[index++] = Protocol.Keyword.GROUP.raw;
        args[index++] = SafeEncoder.encode(groupname);
        args[index++] = SafeEncoder.encode(consumer);
        System.arraycopy(bparams, 0, args, index, paramLength);
        index += paramLength;
        args[index++] = Protocol.Keyword.STREAMS.raw;
        int keyIndex = index;
        int idsIndex = keyIndex + streams.size();
        for (Map.Entry<String, StreamEntryID> entry : streams.entrySet()) {
            args[keyIndex++] = SafeEncoder.encode(entry.getKey());
            args[idsIndex++] = SafeEncoder.encode(entry.getValue().toString());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREADGROUP, args);
    }

    @Override
    public void xpending(String key, String groupname) {
        this.xpending(SafeEncoder.encode(key), SafeEncoder.encode(groupname));
    }

    @Override
    public void xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        this.xpending(SafeEncoder.encode(key), SafeEncoder.encode(groupname), SafeEncoder.encode(start == null ? "-" : start.toString()), SafeEncoder.encode(end == null ? "+" : end.toString()), count, consumername == null ? null : SafeEncoder.encode(consumername));
    }

    @Override
    public void xpending(String key, String groupname, XPendingParams params) {
        this.xpending(SafeEncoder.encode(key), SafeEncoder.encode(groupname), params);
    }

    @Override
    public void xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        byte[][] bids = this.convertStreamEntryIDsToBinary(ids);
        this.xclaim(SafeEncoder.encode(key), SafeEncoder.encode(group), SafeEncoder.encode(consumername), minIdleTime, newIdleTime, retries, force, bids);
    }

    @Override
    public void xclaim(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        byte[][] bids = this.convertStreamEntryIDsToBinary(ids);
        this.xclaim(SafeEncoder.encode(key), SafeEncoder.encode(group), SafeEncoder.encode(consumername), minIdleTime, params, bids);
    }

    @Override
    public void xclaimJustId(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        byte[][] bids = this.convertStreamEntryIDsToBinary(ids);
        this.xclaimJustId(SafeEncoder.encode(key), SafeEncoder.encode(group), SafeEncoder.encode(consumername), minIdleTime, params, bids);
    }

    @Override
    public void xinfoStream(String key) {
        this.xinfoStream(SafeEncoder.encode(key));
    }

    @Override
    public void xinfoGroup(String key) {
        this.xinfoGroup(SafeEncoder.encode(key));
    }

    @Override
    public void xinfoConsumers(String key, String group) {
        this.xinfoConsumers(SafeEncoder.encode(key), SafeEncoder.encode(group));
    }

    private byte[][] convertStreamEntryIDsToBinary(StreamEntryID ... ids) {
        byte[][] bids = new byte[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            bids[i] = SafeEncoder.encode(ids[i].toString());
        }
        return bids;
    }
}

